/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import java.lang.reflect.Method;
import org.spockframework.util.ReflectionUtil;
import org.springframework.test.context.TestContextManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringTestContextManager {
    private static final Method beforeTestClassMethod = ReflectionUtil.getMethodBySignature(TestContextManager.class, (String)"beforeTestClass", (Class[])new Class[0]);
    private static final Method afterTestClassMethod = ReflectionUtil.getMethodBySignature(TestContextManager.class, (String)"afterTestClass", (Class[])new Class[0]);
    private final TestContextManager delegate;

    public SpringTestContextManager(Class<?> clazz) {
        this.delegate = new TestContextManager(clazz);
    }

    public void beforeTestClass() throws Exception {
        if (beforeTestClassMethod != null) {
            ReflectionUtil.invokeMethod((Object)this.delegate, (Method)beforeTestClassMethod, (Object[])new Object[0]);
        }
    }

    public void afterTestClass() throws Exception {
        if (afterTestClassMethod != null) {
            ReflectionUtil.invokeMethod((Object)this.delegate, (Method)afterTestClassMethod, (Object[])new Object[0]);
        }
    }

    public void prepareTestInstance(Object object) throws Exception {
        this.delegate.prepareTestInstance(object);
    }

    public void beforeTestMethod(Object object, Method method) throws Exception {
        this.delegate.beforeTestMethod(object, method);
    }

    public void afterTestMethod(Object object, Method method, Throwable throwable) throws Exception {
        this.delegate.afterTestMethod(object, method, throwable);
    }
}

