/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.openapi.javadoc;

import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.CommentFormatter;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import com.github.therapi.runtimejavadoc.ThrowsJavadoc;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.providers.JavadocProvider;

public class SpringDocJavadocProvider
implements JavadocProvider {
    private final CommentFormatter formatter = new CommentFormatter();

    public String getClassJavadoc(Class<?> cl) {
        ClassJavadoc classJavadoc = RuntimeJavadoc.getJavadoc(cl);
        return this.formatter.format(classJavadoc.getComment());
    }

    public Map<String, String> getRecordClassParamJavadoc(Class<?> cl) {
        ClassJavadoc classJavadoc = RuntimeJavadoc.getJavadoc(cl);
        return classJavadoc.getRecordComponents().stream().collect(Collectors.toMap(ParamJavadoc::getName, recordClass -> this.formatter.format(recordClass.getComment())));
    }

    public String getMethodJavadocDescription(Method method) {
        MethodJavadoc methodJavadoc = RuntimeJavadoc.getJavadoc((Method)method);
        return this.formatter.format(methodJavadoc.getComment());
    }

    public String getMethodJavadocReturn(Method method) {
        MethodJavadoc methodJavadoc = RuntimeJavadoc.getJavadoc((Method)method);
        return this.formatter.format(methodJavadoc.getReturns());
    }

    public Map<String, String> getMethodJavadocThrows(Method method) {
        return RuntimeJavadoc.getJavadoc((Method)method).getThrows().stream().collect(Collectors.toMap(ThrowsJavadoc::getName, javadoc -> this.formatter.format(javadoc.getComment())));
    }

    public String getParamJavadoc(Method method, String name) {
        MethodJavadoc methodJavadoc = RuntimeJavadoc.getJavadoc((Method)method);
        List paramsDoc = methodJavadoc.getParams();
        return paramsDoc.stream().filter(paramJavadoc1 -> name.equals(paramJavadoc1.getName())).findAny().map(paramJavadoc1 -> this.formatter.format(paramJavadoc1.getComment())).orElse(null);
    }

    public String getFieldJavadoc(Field field) {
        FieldJavadoc fieldJavadoc = RuntimeJavadoc.getJavadoc((Field)field);
        return this.formatter.format(fieldJavadoc.getComment());
    }

    public String getFirstSentence(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        int pOpenIndex = text.indexOf("<p>");
        int pCloseIndex = text.indexOf("</p>");
        int dotIndex = text.indexOf(".");
        if (pOpenIndex != -1) {
            if (pOpenIndex == 0 && pCloseIndex != -1) {
                if (dotIndex != -1) {
                    return text.substring(3, Math.min(pCloseIndex, dotIndex));
                }
                return text.substring(3, pCloseIndex);
            }
            if (dotIndex != -1) {
                return text.substring(0, Math.min(pOpenIndex, dotIndex));
            }
            return text.substring(0, pOpenIndex);
        }
        if (dotIndex != -1 && text.length() != dotIndex + 1 && Character.isWhitespace(text.charAt(dotIndex + 1))) {
            return text.substring(0, dotIndex + 1);
        }
        return text;
    }
}

