/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import io.swagger.v3.oas.annotations.Operation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class SwaggerWelcome {
    @Value(value="${server.contextPath:#{''}}")
    private String contextPath1;
    @Value(value="${server.servlet.context-path:#{''}}")
    private String contextPath2;
    @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}")
    private String apiDocsUrl;

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public String redirectToUi() {
        String contextPath = "";
        if (StringUtils.isNotBlank((CharSequence)this.contextPath2)) {
            contextPath = this.contextPath2;
        } else if (StringUtils.isNotBlank((CharSequence)this.contextPath1)) {
            contextPath = this.contextPath1;
        }
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append("redirect:");
        sbUrl.append("/webjars/swagger-ui/index.html?url=");
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
            sbUrl.append(contextPath + this.apiDocsUrl);
        } else {
            sbUrl.append(contextPath + this.apiDocsUrl);
        }
        sbUrl.append("&validatorUrl=");
        return sbUrl.toString();
    }
}

