/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractMessageConverter;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.core.serializer.DefaultDeserializer;
import org.springframework.core.serializer.DefaultSerializer;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializerMessageConverter
extends AbstractMessageConverter {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private volatile String defaultCharset = "UTF-8";
    private volatile Serializer<Object> serializer = new DefaultSerializer();
    private volatile Deserializer<Object> deserializer = new DefaultDeserializer();
    private volatile boolean ignoreContentType = false;

    public void setIgnoreContentType(boolean ignoreContentType) {
        this.ignoreContentType = ignoreContentType;
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset != null ? defaultCharset : DEFAULT_CHARSET;
    }

    public void setSerializer(Serializer<Object> serializer) {
        this.serializer = serializer;
    }

    public void setDeserializer(Deserializer<Object> deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        Object content = null;
        MessageProperties properties = message.getMessageProperties();
        if (properties != null) {
            String contentType = properties.getContentType();
            if (contentType != null && contentType.startsWith("text") && !this.ignoreContentType) {
                String encoding = properties.getContentEncoding();
                if (encoding == null) {
                    encoding = this.defaultCharset;
                }
                try {
                    content = new String(message.getBody(), encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new MessageConversionException("failed to convert text-based Message content", e);
                }
            }
            if (contentType != null && contentType.equals("application/x-java-serialized-object") || this.ignoreContentType) {
                try {
                    content = this.deserializer.deserialize((InputStream)new ByteArrayInputStream(message.getBody()));
                }
                catch (IOException e) {
                    throw new MessageConversionException("Could not convert message body", e);
                }
            }
        }
        if (content == null) {
            content = message.getBody();
        }
        return content;
    }

    @Override
    protected Message createMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        byte[] bytes = null;
        if (object instanceof String) {
            try {
                bytes = ((String)object).getBytes(this.defaultCharset);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageConversionException("failed to convert Message content", e);
            }
            messageProperties.setContentType("text/plain");
            messageProperties.setContentEncoding(this.defaultCharset);
        } else if (object instanceof byte[]) {
            bytes = (byte[])object;
            messageProperties.setContentType("application/octet-stream");
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                this.serializer.serialize(object, (OutputStream)output);
            }
            catch (IOException e) {
                throw new MessageConversionException("Cannot convert object to bytes", e);
            }
            bytes = output.toByteArray();
            messageProperties.setContentType("application/x-java-serialized-object");
        }
        if (bytes != null) {
            messageProperties.setContentLength(bytes.length);
        }
        return new Message(bytes, messageProperties);
    }
}

