/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.MessageDeliveryMode;

public class MessageProperties
implements Serializable {
    private static final long serialVersionUID = 1619000546531112290L;
    public static final String CONTENT_TYPE_BYTES = "application/octet-stream";
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_SERIALIZED_OBJECT = "application/x-java-serialized-object";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_JSON_ALT = "text/x-json";
    public static final String CONTENT_TYPE_XML = "application/xml";
    public static final String SPRING_BATCH_FORMAT = "springBatchFormat";
    public static final String BATCH_FORMAT_LENGTH_HEADER4 = "lengthHeader4";
    public static final String SPRING_AUTO_DECOMPRESS = "springAutoDecompress";
    public static final String X_DELAY = "x-delay";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final MessageDeliveryMode DEFAULT_DELIVERY_MODE = MessageDeliveryMode.PERSISTENT;
    public static final Integer DEFAULT_PRIORITY = 0;
    private final Map<String, Object> headers = new HashMap<String, Object>();
    private volatile Date timestamp;
    private volatile String messageId;
    private volatile String userId;
    private volatile String appId;
    private volatile String clusterId;
    private volatile String type;
    private volatile String correlationId;
    private volatile String replyTo;
    private volatile String contentType = "application/octet-stream";
    private volatile String contentEncoding;
    private volatile long contentLength;
    private volatile boolean contentLengthSet;
    private volatile MessageDeliveryMode deliveryMode = DEFAULT_DELIVERY_MODE;
    private volatile String expiration;
    private volatile Integer priority = DEFAULT_PRIORITY;
    private volatile Boolean redelivered;
    private volatile String receivedExchange;
    private volatile String receivedRoutingKey;
    private volatile String receivedUserId;
    private volatile long deliveryTag;
    private volatile boolean deliveryTagSet;
    private volatile Integer messageCount;
    private volatile String consumerTag;
    private volatile String consumerQueue;
    private volatile Integer receivedDelay;
    private volatile MessageDeliveryMode receivedDeliveryMode;
    private volatile boolean finalRetryForMessageWithNoId;
    private volatile transient Type inferredArgumentType;
    private volatile transient Method targetMethod;
    private volatile transient Object targetBean;

    public void setHeader(String key, Object value) {
        this.headers.put(key, value);
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getReceivedUserId() {
        return this.receivedUserId;
    }

    public void setReceivedUserId(String receivedUserId) {
        this.receivedUserId = receivedUserId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    @Deprecated
    public String getCorrelationIdString() {
        return this.correlationId;
    }

    @Deprecated
    public void setCorrelationIdString(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyToAddress(Address replyTo) {
        this.replyTo = replyTo != null ? replyTo.toString() : null;
    }

    public Address getReplyToAddress() {
        return this.replyTo != null ? new Address(this.replyTo) : null;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
        this.contentLengthSet = true;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    protected final boolean isContentLengthSet() {
        return this.contentLengthSet;
    }

    public void setDeliveryMode(MessageDeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public MessageDeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    public MessageDeliveryMode getReceivedDeliveryMode() {
        return this.receivedDeliveryMode;
    }

    public void setReceivedDeliveryMode(MessageDeliveryMode receivedDeliveryMode) {
        this.receivedDeliveryMode = receivedDeliveryMode;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setReceivedExchange(String receivedExchange) {
        this.receivedExchange = receivedExchange;
    }

    public String getReceivedExchange() {
        return this.receivedExchange;
    }

    public void setReceivedRoutingKey(String receivedRoutingKey) {
        this.receivedRoutingKey = receivedRoutingKey;
    }

    public String getReceivedRoutingKey() {
        return this.receivedRoutingKey;
    }

    public Integer getReceivedDelay() {
        return this.receivedDelay;
    }

    public void setReceivedDelay(Integer receivedDelay) {
        this.receivedDelay = receivedDelay;
    }

    public void setRedelivered(Boolean redelivered) {
        this.redelivered = redelivered;
    }

    public Boolean isRedelivered() {
        return this.redelivered;
    }

    public Boolean getRedelivered() {
        return this.redelivered;
    }

    public void setDeliveryTag(long deliveryTag) {
        this.deliveryTag = deliveryTag;
        this.deliveryTagSet = true;
    }

    public long getDeliveryTag() {
        return this.deliveryTag;
    }

    protected final boolean isDeliveryTagSet() {
        return this.deliveryTagSet;
    }

    public void setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
    }

    public Integer getMessageCount() {
        return this.messageCount;
    }

    public String getConsumerTag() {
        return this.consumerTag;
    }

    public void setConsumerTag(String consumerTag) {
        this.consumerTag = consumerTag;
    }

    public String getConsumerQueue() {
        return this.consumerQueue;
    }

    public void setConsumerQueue(String consumerQueue) {
        this.consumerQueue = consumerQueue;
    }

    public Integer getDelay() {
        Object delay = this.headers.get(X_DELAY);
        if (delay instanceof Integer) {
            return (Integer)delay;
        }
        return null;
    }

    public void setDelay(Integer delay) {
        if (delay == null || delay < 0) {
            this.headers.remove(X_DELAY);
        } else {
            this.headers.put(X_DELAY, delay);
        }
    }

    public boolean isFinalRetryForMessageWithNoId() {
        return this.finalRetryForMessageWithNoId;
    }

    public void setFinalRetryForMessageWithNoId(boolean finalRetryForMessageWithNoId) {
        this.finalRetryForMessageWithNoId = finalRetryForMessageWithNoId;
    }

    public Type getInferredArgumentType() {
        return this.inferredArgumentType;
    }

    public void setInferredArgumentType(Type inferredArgumentType) {
        this.inferredArgumentType = inferredArgumentType;
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public void setTargetMethod(Method targetMethod) {
        this.targetMethod = targetMethod;
    }

    public Object getTargetBean() {
        return this.targetBean;
    }

    public void setTargetBean(Object targetBean) {
        this.targetBean = targetBean;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appId == null ? 0 : this.appId.hashCode());
        result = 31 * result + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        result = 31 * result + (this.contentEncoding == null ? 0 : this.contentEncoding.hashCode());
        result = 31 * result + (int)(this.contentLength ^ this.contentLength >>> 32);
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = 31 * result + (this.correlationId == null ? 0 : this.correlationId.hashCode());
        result = 31 * result + (this.deliveryMode == null ? 0 : this.deliveryMode.hashCode());
        result = 31 * result + (int)(this.deliveryTag ^ this.deliveryTag >>> 32);
        result = 31 * result + (this.expiration == null ? 0 : this.expiration.hashCode());
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + (this.messageCount == null ? 0 : this.messageCount.hashCode());
        result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + (this.receivedExchange == null ? 0 : this.receivedExchange.hashCode());
        result = 31 * result + (this.receivedRoutingKey == null ? 0 : this.receivedRoutingKey.hashCode());
        result = 31 * result + (this.redelivered == null ? 0 : this.redelivered.hashCode());
        result = 31 * result + (this.replyTo == null ? 0 : this.replyTo.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageProperties other = (MessageProperties)obj;
        if (this.appId == null ? other.appId != null : !this.appId.equals(other.appId)) {
            return false;
        }
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.contentEncoding == null ? other.contentEncoding != null : !this.contentEncoding.equals(other.contentEncoding)) {
            return false;
        }
        if (this.contentLength != other.contentLength) {
            return false;
        }
        if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
            return false;
        }
        if (this.correlationId == null ? other.correlationId != null : !this.correlationId.equals(other.correlationId)) {
            return false;
        }
        if (this.deliveryMode != other.deliveryMode) {
            return false;
        }
        if (this.deliveryTag != other.deliveryTag) {
            return false;
        }
        if (this.expiration == null ? other.expiration != null : !this.expiration.equals(other.expiration)) {
            return false;
        }
        if (!this.headers.equals(other.headers)) {
            return false;
        }
        if (this.messageCount == null ? other.messageCount != null : !this.messageCount.equals(other.messageCount)) {
            return false;
        }
        if (this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId)) {
            return false;
        }
        if (this.priority == null ? other.priority != null : !this.priority.equals(other.priority)) {
            return false;
        }
        if (this.receivedExchange == null ? other.receivedExchange != null : !this.receivedExchange.equals(other.receivedExchange)) {
            return false;
        }
        if (this.receivedRoutingKey == null ? other.receivedRoutingKey != null : !this.receivedRoutingKey.equals(other.receivedRoutingKey)) {
            return false;
        }
        if (this.redelivered == null ? other.redelivered != null : !this.redelivered.equals(other.redelivered)) {
            return false;
        }
        if (this.replyTo == null ? other.replyTo != null : !this.replyTo.equals(other.replyTo)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }

    public String toString() {
        return "MessageProperties [headers=" + this.headers + (this.timestamp == null ? "" : ", timestamp=" + this.timestamp) + (this.messageId == null ? "" : ", messageId=" + this.messageId) + (this.userId == null ? "" : ", userId=" + this.userId) + (this.receivedUserId == null ? "" : ", receivedUserId=" + this.receivedUserId) + (this.appId == null ? "" : ", appId=" + this.appId) + (this.clusterId == null ? "" : ", clusterId=" + this.clusterId) + (this.type == null ? "" : ", type=" + this.type) + (this.correlationId == null ? "" : ", correlationId=" + this.correlationId) + (this.replyTo == null ? "" : ", replyTo=" + this.replyTo) + (this.contentType == null ? "" : ", contentType=" + this.contentType) + (this.contentEncoding == null ? "" : ", contentEncoding=" + this.contentEncoding) + ", contentLength=" + this.contentLength + (this.deliveryMode == null ? "" : ", deliveryMode=" + (Object)((Object)this.deliveryMode)) + (this.receivedDeliveryMode == null ? "" : ", receivedDeliveryMode=" + (Object)((Object)this.receivedDeliveryMode)) + (this.expiration == null ? "" : ", expiration=" + this.expiration) + (this.priority == null ? "" : ", priority=" + this.priority) + (this.redelivered == null ? "" : ", redelivered=" + this.redelivered) + (this.receivedExchange == null ? "" : ", receivedExchange=" + this.receivedExchange) + (this.receivedRoutingKey == null ? "" : ", receivedRoutingKey=" + this.receivedRoutingKey) + (this.receivedDelay == null ? "" : ", receivedDelay=" + this.receivedDelay) + ", deliveryTag=" + this.deliveryTag + (this.messageCount == null ? "" : ", messageCount=" + this.messageCount) + (this.consumerTag == null ? "" : ", consumerTag=" + this.consumerTag) + (this.consumerQueue == null ? "" : ", consumerQueue=" + this.consumerQueue) + "]";
    }
}

