/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultSaslConfig;
import com.rabbitmq.client.JDKSaslConfig;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.CRDemoMechanism;
import com.rabbitmq.client.impl.recovery.AutorecoveringChannel;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class RabbitUtils {
    public static final int DECLARE_METHOD_ID_10 = 10;
    public static final int CONSUME_METHOD_ID_20 = 20;
    public static final int EXCHANGE_CLASS_ID_40 = 40;
    public static final int QUEUE_CLASS_ID_50 = 50;
    public static final int BASIC_CLASS_ID_60 = 60;
    public static final int CONNECTION_PROTOCOL_CLASS_ID_10 = 10;
    public static final int CHANNEL_PROTOCOL_CLASS_ID_20 = 20;
    private static final Log LOGGER = LogFactory.getLog(RabbitUtils.class);
    private static final ThreadLocal<Boolean> physicalCloseRequired = new ThreadLocal();

    public static void closeConnection(@Nullable Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (AlreadyClosedException alreadyClosedException) {
            }
            catch (Exception ex) {
                LOGGER.debug((Object)("Ignoring Connection exception - assuming already closed: " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public static void closeChannel(@Nullable Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (AlreadyClosedException alreadyClosedException) {
            }
            catch (IOException ex) {
                LOGGER.debug((Object)"Could not close RabbitMQ Channel", (Throwable)ex);
            }
            catch (ShutdownSignalException sig) {
                if (!RabbitUtils.isNormalShutdown(sig)) {
                    LOGGER.debug((Object)"Unexpected exception on closing RabbitMQ Channel", (Throwable)sig);
                }
            }
            catch (Exception ex) {
                LOGGER.debug((Object)"Unexpected exception on closing RabbitMQ Channel", (Throwable)ex);
            }
        }
    }

    public static void commitIfNecessary(Channel channel) {
        Assert.notNull((Object)channel, (String)"Channel must not be null");
        try {
            channel.txCommit();
        }
        catch (IOException ex) {
            throw new AmqpIOException(ex);
        }
    }

    public static void rollbackIfNecessary(Channel channel) {
        Assert.notNull((Object)channel, (String)"Channel must not be null");
        try {
            channel.txRollback();
        }
        catch (IOException ex) {
            throw new AmqpIOException(ex);
        }
    }

    public static void closeMessageConsumer(Channel channel, Collection<String> consumerTags, boolean transactional) {
        Object proxy;
        if (!(channel.isOpen() || channel instanceof ChannelProxy && (proxy = (ChannelProxy)channel).getTargetChannel() instanceof AutorecoveringChannel || channel instanceof AutorecoveringChannel)) {
            return;
        }
        try {
            for (String consumerTag : consumerTags) {
                RabbitUtils.cancel(channel, consumerTag);
            }
            if (transactional) {
                channel.basicRecover(true);
            }
        }
        catch (Exception ex) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(ex);
        }
    }

    public static void cancel(Channel channel, String consumerTag) {
        block4: {
            try {
                channel.basicCancel(consumerTag);
            }
            catch (AlreadyClosedException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)(channel + " is already closed"), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug((Object)("Error performing 'basicCancel' on " + channel), (Throwable)e);
            }
        }
    }

    public static void declareTransactional(Channel channel) {
        try {
            channel.txSelect();
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    public static void setPhysicalCloseRequired(Channel channel, boolean b) {
        if (channel instanceof ChannelProxy) {
            physicalCloseRequired.set(b);
        }
    }

    public static boolean isPhysicalCloseRequired() {
        Boolean mustClose = physicalCloseRequired.get();
        if (mustClose == null) {
            return false;
        }
        return mustClose;
    }

    public static void clearPhysicalCloseRequired() {
        physicalCloseRequired.remove();
    }

    public static boolean isNormalShutdown(ShutdownSignalException sig) {
        AMQP.Connection.Close closeReason;
        Method shutdownReason = sig.getReason();
        return shutdownReason instanceof AMQP.Connection.Close && 200 == (closeReason = (AMQP.Connection.Close)shutdownReason).getReplyCode() && "OK".equals(closeReason.getReplyText());
    }

    public static boolean isNormalChannelClose(ShutdownSignalException sig) {
        AMQP.Channel.Close closeReason;
        Method shutdownReason = sig.getReason();
        return RabbitUtils.isNormalShutdown(sig) || shutdownReason instanceof AMQP.Channel.Close && 200 == (closeReason = (AMQP.Channel.Close)shutdownReason).getReplyCode() && "OK".equals(closeReason.getReplyText());
    }

    public static boolean isPassiveDeclarationChannelClose(ShutdownSignalException sig) {
        AMQP.Channel.Close closeReason;
        Method shutdownReason = sig.getReason();
        return shutdownReason instanceof AMQP.Channel.Close && 404 == (closeReason = (AMQP.Channel.Close)shutdownReason).getReplyCode() && (closeReason.getClassId() == 40 || closeReason.getClassId() == 50) && closeReason.getMethodId() == 10;
    }

    public static boolean isExclusiveUseChannelClose(ShutdownSignalException sig) {
        AMQP.Channel.Close closeReason;
        Method shutdownReason = sig.getReason();
        return shutdownReason instanceof AMQP.Channel.Close && 403 == (closeReason = (AMQP.Channel.Close)shutdownReason).getReplyCode() && closeReason.getClassId() == 60 && closeReason.getMethodId() == 20 && closeReason.getReplyText().contains("exclusive");
    }

    public static boolean isMismatchedQueueArgs(Exception e) {
        AMQP.Channel.Close closeReason;
        ShutdownSignalException sig = null;
        for (Throwable cause = e; cause != null && sig == null; cause = cause.getCause()) {
            if (!(cause instanceof ShutdownSignalException)) continue;
            sig = (ShutdownSignalException)cause;
        }
        if (sig == null) {
            return false;
        }
        Method shutdownReason = sig.getReason();
        return shutdownReason instanceof AMQP.Channel.Close && 406 == (closeReason = (AMQP.Channel.Close)shutdownReason).getReplyCode() && closeReason.getClassId() == 50 && closeReason.getMethodId() == 10;
    }

    public static boolean isExchangeDeclarationFailure(Exception e) {
        AMQP.Connection.Close closeReason;
        ShutdownSignalException sig = null;
        for (Throwable cause = e; cause != null && sig == null; cause = cause.getCause()) {
            if (!(cause instanceof ShutdownSignalException)) continue;
            sig = (ShutdownSignalException)cause;
        }
        if (sig == null) {
            return false;
        }
        Method shutdownReason = sig.getReason();
        return shutdownReason instanceof AMQP.Connection.Close && 503 == (closeReason = (AMQP.Connection.Close)shutdownReason).getReplyCode() && closeReason.getClassId() == 40 && closeReason.getMethodId() == 10;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getMaxFrame(ConnectionFactory connectionFactory) {
        try (Connection connection = connectionFactory.createConnection();){
            com.rabbitmq.client.Connection rcon = connection.getDelegate();
            if (rcon == null) return -1;
            int n = rcon.getFrameMax();
            return n;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return -1;
    }

    public static SaslConfig stringToSaslConfig(String saslConfig, com.rabbitmq.client.ConnectionFactory connectionFactory) {
        switch (saslConfig) {
            case "DefaultSaslConfig.PLAIN": {
                return DefaultSaslConfig.PLAIN;
            }
            case "DefaultSaslConfig.EXTERNAL": {
                return DefaultSaslConfig.EXTERNAL;
            }
            case "JDKSaslConfig": {
                return new JDKSaslConfig(connectionFactory);
            }
            case "CRDemoSaslConfig": {
                return new CRDemoMechanism.CRDemoSaslConfig();
            }
        }
        throw new IllegalStateException("Unrecognized SaslConfig: " + saslConfig);
    }
}

