/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cloudfoundry;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class VcapApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final Log logger = LogFactory.getLog(VcapApplicationListener.class);
    private static final String VCAP_APPLICATION = "VCAP_APPLICATION";
    private static final String VCAP_SERVICES = "VCAP_SERVICES";
    private int order = -2147483639;
    private final JsonParser parser = JsonParserFactory.getJsonParser();

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (!environment.containsProperty(VCAP_APPLICATION) && !environment.containsProperty(VCAP_SERVICES)) {
            return;
        }
        Properties properties = new Properties();
        this.addWithPrefix(properties, this.getPropertiesFromApplication((Environment)environment), "vcap.application.");
        this.addWithPrefix(properties, this.getPropertiesFromServices((Environment)environment), "vcap.services.");
        MutablePropertySources propertySources = environment.getPropertySources();
        if (propertySources.contains("commandLineArgs")) {
            propertySources.addAfter("commandLineArgs", (PropertySource)new PropertiesPropertySource("vcap", properties));
        } else {
            propertySources.addFirst((PropertySource)new PropertiesPropertySource("vcap", properties));
        }
    }

    private void addWithPrefix(Properties properties, Properties other, String prefix) {
        for (String key : other.stringPropertyNames()) {
            String prefixed = prefix + key;
            properties.setProperty(prefixed, other.getProperty(key));
        }
    }

    private Properties getPropertiesFromApplication(Environment environment) {
        Properties properties = new Properties();
        try {
            Map<String, Object> map = this.parser.parseMap(environment.getProperty(VCAP_APPLICATION, "{}"));
            if (map != null) {
                map = new LinkedHashMap<String, Object>(map);
                for (String key : map.keySet()) {
                    Object value = map.get(key);
                    if (value instanceof String) continue;
                    if (value == null) {
                        value = "";
                    }
                    map.put(key, value.toString());
                }
                properties.putAll(map);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Could not parse VCAP_APPLICATION", (Throwable)ex);
        }
        return properties;
    }

    private Properties getPropertiesFromServices(Environment environment) {
        Properties properties = new Properties();
        try {
            Map<String, Object> map = this.parser.parseMap(environment.getProperty(VCAP_SERVICES, "{}"));
            if (map != null) {
                for (Object services : map.values()) {
                    List list = (List)services;
                    for (Object object : list) {
                        Map service = (Map)object;
                        String key = (String)service.get("name");
                        if (key == null) {
                            key = (String)service.get("label");
                        }
                        this.flatten(properties, service, key);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Could not parse VCAP_SERVICES", (Throwable)ex);
        }
        return properties;
    }

    private void flatten(Properties properties, Map<String, Object> input, String path) {
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (StringUtils.hasText((String)path)) {
                key = key.startsWith("[") ? path + key : path + "." + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                properties.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.flatten(properties, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                properties.put(key, StringUtils.collectionToCommaDelimitedString((Collection)collection));
                int count = 0;
                for (Object object : collection) {
                    this.flatten(properties, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            properties.put(key, value == null ? "" : value);
        }
    }
}

