/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.springframework.boot.test.Base64;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class TestRestTemplate
extends RestTemplate {
    public TestRestTemplate() {
        this(null, null);
    }

    public TestRestTemplate(String username, String password) {
        super(TestRestTemplate.getRequestFactory(username, password));
        if (ClassUtils.isPresent((String)"org.apache.http.client.config.RequestConfig", null)) {
            new HttpComponentsCustomizer().customize(this);
        }
        this.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) throws IOException {
            }
        });
    }

    private static ClientHttpRequestFactory getRequestFactory(String username, String password) {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        if (username == null) {
            return factory;
        }
        List<BasicAuthorizationInterceptor> interceptors = Collections.singletonList(new BasicAuthorizationInterceptor(username, password));
        return new InterceptingClientHttpRequestFactory((ClientHttpRequestFactory)factory, interceptors);
    }

    private static class HttpComponentsCustomizer {
        private HttpComponentsCustomizer() {
        }

        public void customize(RestTemplate restTemplate) {
            restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(){

                protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
                    HttpClientContext context = HttpClientContext.create();
                    RequestConfig.Builder builder = RequestConfig.custom().setCookieSpec("ignoreCookies").setAuthenticationEnabled(false).setRedirectsEnabled(false);
                    context.setRequestConfig(builder.build());
                    return context;
                }
            });
        }
    }

    private static class BasicAuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        private final String username;
        private final String password;

        public BasicAuthorizationInterceptor(String username, String password) {
            this.username = username;
            this.password = password == null ? "" : password;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            byte[] token = Base64.encode((this.username + ":" + this.password).getBytes());
            request.getHeaders().add("Authorization", "Basic " + new String(token));
            return execution.execute(request, body);
        }
    }
}

