/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.orm.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.orm.jpa.EntityScan;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class EntityScanRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String BEAN_NAME = "entityScanBeanPostProcessor";

    EntityScanRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(BEAN_NAME)) {
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(EntityScanBeanPostProcessor.class);
            beanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)this.getPackagesToScan(importingClassMetadata));
            beanDefinition.setRole(2);
            beanDefinition.setSynthetic(true);
            registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)beanDefinition);
        }
    }

    private String[] getPackagesToScan(AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(EntityScan.class.getName()));
        Object[] value = attributes.getStringArray("value");
        Object[] basePackages = attributes.getStringArray("basePackages");
        Class[] basePackageClasses = attributes.getClassArray("basePackageClasses");
        if (!ObjectUtils.isEmpty((Object[])value)) {
            Assert.state((boolean)ObjectUtils.isEmpty((Object[])basePackages), (String)"@EntityScan basePackages and value attributes are mutually exclusive");
        }
        LinkedHashSet<Object> packagesToScan = new LinkedHashSet<Object>();
        packagesToScan.addAll(Arrays.asList(value));
        packagesToScan.addAll(Arrays.asList(basePackages));
        for (Class basePackageClass : basePackageClasses) {
            packagesToScan.add(ClassUtils.getPackageName((Class)basePackageClass));
        }
        if (packagesToScan.isEmpty()) {
            return new String[]{ClassUtils.getPackageName((String)metadata.getClassName())};
        }
        return new ArrayList(packagesToScan).toArray(new String[packagesToScan.size()]);
    }

    static class EntityScanBeanPostProcessor
    implements BeanPostProcessor,
    ApplicationListener<ContextRefreshedEvent> {
        private final String[] packagesToScan;
        private boolean processed;

        public EntityScanBeanPostProcessor(String[] packagesToScan) {
            this.packagesToScan = packagesToScan;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof LocalContainerEntityManagerFactoryBean) {
                LocalContainerEntityManagerFactoryBean factoryBean = (LocalContainerEntityManagerFactoryBean)bean;
                factoryBean.setPackagesToScan(this.packagesToScan);
                this.processed = true;
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public void onApplicationEvent(ContextRefreshedEvent event) {
            Assert.state((boolean)this.processed, (String)"Unable to configure LocalContainerEntityManagerFactoryBean from @EntityScan, ensure an appropriate bean is registered.");
        }
    }
}

