/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.undertow;

import io.undertow.Undertow;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.boot.context.embedded.MimeMappings;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainer;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SocketUtils;
import org.springframework.util.StringUtils;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

public class UndertowEmbeddedServletContainerFactory
extends AbstractEmbeddedServletContainerFactory
implements ResourceLoaderAware {
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    private List<UndertowBuilderCustomizer> builderCustomizers = new ArrayList<UndertowBuilderCustomizer>();
    private List<UndertowDeploymentInfoCustomizer> deploymentInfoCustomizers = new ArrayList<UndertowDeploymentInfoCustomizer>();
    private ResourceLoader resourceLoader;
    private Integer bufferSize;
    private Integer buffersPerRegion;
    private Integer ioThreads;
    private Integer workerThreads;
    private Boolean directBuffers;

    public UndertowEmbeddedServletContainerFactory() {
        this.setRegisterJspServlet(false);
    }

    public UndertowEmbeddedServletContainerFactory(int port) {
        super(port);
        this.setRegisterJspServlet(false);
    }

    public UndertowEmbeddedServletContainerFactory(String contextPath, int port) {
        super(contextPath, port);
        this.setRegisterJspServlet(false);
    }

    public void setBuilderCustomizers(Collection<? extends UndertowBuilderCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers must not be null");
        this.builderCustomizers = new ArrayList<UndertowBuilderCustomizer>(customizers);
    }

    public Collection<UndertowBuilderCustomizer> getBuilderCustomizers() {
        return this.builderCustomizers;
    }

    public void addBuilderCustomizers(UndertowBuilderCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers must not be null");
        this.builderCustomizers.addAll(Arrays.asList(customizers));
    }

    public void setDeploymentInfoCustomizers(Collection<? extends UndertowDeploymentInfoCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers must not be null");
        this.deploymentInfoCustomizers = new ArrayList<UndertowDeploymentInfoCustomizer>(customizers);
    }

    public Collection<UndertowDeploymentInfoCustomizer> getDeploymentInfoCustomizers() {
        return this.deploymentInfoCustomizers;
    }

    public void addDeploymentInfoCustomizers(UndertowDeploymentInfoCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"UndertowDeploymentInfoCustomizers must not be null");
        this.deploymentInfoCustomizers.addAll(Arrays.asList(customizers));
    }

    @Override
    public EmbeddedServletContainer getEmbeddedServletContainer(ServletContextInitializer ... initializers) {
        DeploymentManager manager = this.createDeploymentManager(initializers);
        int port = this.getPort();
        if (port == 0) {
            port = SocketUtils.findAvailableTcpPort((int)40000);
        }
        Undertow.Builder builder = this.createBuilder(port);
        return new UndertowEmbeddedServletContainer(builder, manager, this.getContextPath(), port, port >= 0);
    }

    private Undertow.Builder createBuilder(int port) {
        Undertow.Builder builder = Undertow.builder();
        if (this.bufferSize != null) {
            builder.setBufferSize(this.bufferSize.intValue());
        }
        if (this.buffersPerRegion != null) {
            builder.setBuffersPerRegion(this.buffersPerRegion.intValue());
        }
        if (this.ioThreads != null) {
            builder.setIoThreads(this.ioThreads.intValue());
        }
        if (this.workerThreads != null) {
            builder.setWorkerThreads(this.workerThreads.intValue());
        }
        if (this.directBuffers != null) {
            builder.setDirectBuffers(this.directBuffers.booleanValue());
        }
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.configureSsl(this.getSsl(), port, builder);
        } else {
            builder.addHttpListener(port, this.getListenAddress());
        }
        for (UndertowBuilderCustomizer customizer : this.builderCustomizers) {
            customizer.customize(builder);
        }
        return builder;
    }

    private void configureSsl(Ssl ssl, int port, Undertow.Builder builder) {
        try {
            SSLContext sslContext = SSLContext.getInstance(ssl.getProtocol());
            sslContext.init(this.getKeyManagers(), this.getTrustManagers(), null);
            builder.addHttpsListener(port, this.getListenAddress(), sslContext);
            builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)this.getSslClientAuthMode(ssl));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
        catch (KeyManagementException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String getListenAddress() {
        if (this.getAddress() == null) {
            return "0.0.0.0";
        }
        return this.getAddress().getHostAddress();
    }

    private SslClientAuthMode getSslClientAuthMode(Ssl ssl) {
        if (ssl.getClientAuth() == Ssl.ClientAuth.NEED) {
            return SslClientAuthMode.REQUIRED;
        }
        if (ssl.getClientAuth() == Ssl.ClientAuth.WANT) {
            return SslClientAuthMode.REQUESTED;
        }
        return SslClientAuthMode.NOT_REQUESTED;
    }

    private KeyManager[] getKeyManagers() {
        try {
            Ssl ssl = this.getSsl();
            String keyStoreType = ssl.getKeyStoreType();
            if (keyStoreType == null) {
                keyStoreType = "JKS";
            }
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            URL url = ResourceUtils.getURL((String)ssl.getKeyStore());
            keyStore.load(url.openStream(), ssl.getKeyStorePassword().toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            char[] keyPassword = ssl.getKeyPassword() != null ? ssl.getKeyPassword().toCharArray() : ssl.getKeyStorePassword().toCharArray();
            keyManagerFactory.init(keyStore, keyPassword);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private TrustManager[] getTrustManagers() {
        try {
            String trustStore;
            Ssl ssl = this.getSsl();
            String trustStoreType = ssl.getTrustStoreType();
            if (trustStoreType == null) {
                trustStoreType = "JKS";
            }
            if ((trustStore = ssl.getTrustStore()) == null) {
                return null;
            }
            KeyStore trustedKeyStore = KeyStore.getInstance(trustStoreType);
            URL url = ResourceUtils.getURL((String)trustStore);
            trustedKeyStore.load(url.openStream(), ssl.getTrustStorePassword().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustedKeyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private DeploymentManager createDeploymentManager(ServletContextInitializer ... initializers) {
        DeploymentInfo deployment = Servlets.deployment();
        this.registerServletContainerInitializerToDriveServletContextInitializers(deployment, initializers);
        deployment.setClassLoader(this.getServletClassLoader());
        String contextPath = this.getContextPath();
        deployment.setContextPath(StringUtils.hasLength((String)contextPath) ? contextPath : "/");
        deployment.setDeploymentName("spring-boot");
        if (this.isRegisterDefaultServlet()) {
            deployment.addServlet(Servlets.servlet((String)"default", DefaultServlet.class));
        }
        this.configureErrorPages(deployment);
        deployment.setServletStackTraces(ServletStackTraces.NONE);
        deployment.setResourceManager(this.getDocumentRootResourceManager());
        this.configureMimeMappings(deployment);
        for (UndertowDeploymentInfoCustomizer customizer : this.deploymentInfoCustomizers) {
            customizer.customize(deployment);
        }
        DeploymentManager manager = Servlets.defaultContainer().addDeployment(deployment);
        manager.deploy();
        SessionManager sessionManager = manager.getDeployment().getSessionManager();
        int sessionTimeout = this.getSessionTimeout() > 0 ? this.getSessionTimeout() : -1;
        sessionManager.setDefaultSessionTimeout(sessionTimeout);
        return manager;
    }

    private void registerServletContainerInitializerToDriveServletContextInitializers(DeploymentInfo deployment, ServletContextInitializer ... initializers) {
        ServletContextInitializer[] mergedInitializers = this.mergeInitializers(initializers);
        Initializer initializer = new Initializer(mergedInitializers);
        deployment.addServletContainerInitalizer(new ServletContainerInitializerInfo(Initializer.class, (InstanceFactory)new ImmediateInstanceFactory((Object)initializer), NO_CLASSES));
    }

    private ClassLoader getServletClassLoader() {
        if (this.resourceLoader != null) {
            return this.resourceLoader.getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    private ResourceManager getDocumentRootResourceManager() {
        File root = this.getValidDocumentRoot();
        if (root != null && root.isDirectory()) {
            return new FileResourceManager(root, 0L);
        }
        if (root != null && root.isFile()) {
            return new JarResourcemanager(root);
        }
        if (this.resourceLoader != null) {
            return new ClassPathResourceManager(this.resourceLoader.getClassLoader(), "");
        }
        return new ClassPathResourceManager(this.getClass().getClassLoader(), "");
    }

    private void configureErrorPages(DeploymentInfo servletBuilder) {
        for (ErrorPage errorPage : this.getErrorPages()) {
            servletBuilder.addErrorPage(this.getUndertowErrorPage(errorPage));
        }
    }

    private io.undertow.servlet.api.ErrorPage getUndertowErrorPage(ErrorPage errorPage) {
        if (errorPage.getStatus() != null) {
            return new io.undertow.servlet.api.ErrorPage(errorPage.getPath(), errorPage.getStatusCode());
        }
        if (errorPage.getException() != null) {
            return new io.undertow.servlet.api.ErrorPage(errorPage.getPath(), errorPage.getException());
        }
        return new io.undertow.servlet.api.ErrorPage(errorPage.getPath());
    }

    private void configureMimeMappings(DeploymentInfo servletBuilder) {
        for (MimeMappings.Mapping mimeMapping : this.getMimeMappings()) {
            servletBuilder.addMimeMapping(new MimeMapping(mimeMapping.getExtension(), mimeMapping.getMimeType()));
        }
    }

    protected UndertowEmbeddedServletContainer getUndertowEmbeddedServletContainer(Undertow.Builder builder, DeploymentManager manager, int port) {
        return new UndertowEmbeddedServletContainer(builder, manager, this.getContextPath(), port, port >= 0);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setBuffersPerRegion(Integer buffersPerRegion) {
        this.buffersPerRegion = buffersPerRegion;
    }

    public void setIoThreads(Integer ioThreads) {
        this.ioThreads = ioThreads;
    }

    public void setWorkerThreads(Integer workerThreads) {
        this.workerThreads = workerThreads;
    }

    public void setDirectBuffers(Boolean directBuffers) {
        this.directBuffers = directBuffers;
    }

    @Override
    public void setRegisterJspServlet(boolean registerJspServlet) {
        Assert.isTrue((!registerJspServlet ? 1 : 0) != 0, (String)"Undertow does not support JSPs");
        super.setRegisterJspServlet(registerJspServlet);
    }

    private static class Initializer
    implements ServletContainerInitializer {
        private final ServletContextInitializer[] initializers;

        public Initializer(ServletContextInitializer[] initializers) {
            this.initializers = initializers;
        }

        public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
            for (ServletContextInitializer initializer : this.initializers) {
                initializer.onStartup(servletContext);
            }
        }
    }

    private static class JarResourcemanager
    implements ResourceManager {
        private final String jarPath;

        public JarResourcemanager(File jarFile) {
            this(jarFile.getAbsolutePath());
        }

        public JarResourcemanager(String jarPath) {
            this.jarPath = jarPath;
        }

        public Resource getResource(String path) throws IOException {
            URL url = new URL("jar:file:" + this.jarPath + "!" + path);
            URLResource resource = new URLResource(url, url.openConnection(), path);
            if (resource.getContentLength() < 0L) {
                return null;
            }
            return resource;
        }

        public boolean isResourceChangeListenerSupported() {
            return false;
        }

        public void registerResourceChangeListener(ResourceChangeListener listener) {
            throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
        }

        public void removeResourceChangeListener(ResourceChangeListener listener) {
            throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
        }

        public void close() throws IOException {
        }
    }
}

