/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.integration.channel.FluxMessageChannel;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class FluxMessageChannelBindingTargetFactory
extends AbstractBindingTargetFactory<FluxMessageChannel> {
    private final MessageChannelConfigurer messageChannelConfigurer;
    private final GenericApplicationContext context;

    public FluxMessageChannelBindingTargetFactory(MessageChannelConfigurer messageChannelConfigurer, GenericApplicationContext context) {
        super(FluxMessageChannel.class);
        Assert.notNull((Object)context, (String)"'context' must not be null");
        this.messageChannelConfigurer = messageChannelConfigurer;
        this.context = context;
    }

    @Override
    public FluxMessageChannel createInput(String name) {
        FluxMessageChannel fluxMessageChannel = this.fluxMessageChannel(name);
        this.messageChannelConfigurer.configureInputChannel((MessageChannel)fluxMessageChannel, name);
        return fluxMessageChannel;
    }

    @Override
    public FluxMessageChannel createOutput(String name) {
        FluxMessageChannel fluxMessageChannel = this.fluxMessageChannel(name);
        this.messageChannelConfigurer.configureOutputChannel((MessageChannel)fluxMessageChannel, name);
        return fluxMessageChannel;
    }

    public FluxMessageChannel fluxMessageChannel(String name) {
        FluxMessageChannel fluxMessageChannel = null;
        if (this.context.containsBean(name)) {
            fluxMessageChannel = (FluxMessageChannel)this.context.getBean(name, FluxMessageChannel.class);
        }
        if (fluxMessageChannel == null) {
            FluxMessageChannel channel = new FluxMessageChannel();
            channel.setComponentName(name);
            this.context.registerBean(name, FluxMessageChannel.class, () -> channel, new BeanDefinitionCustomizer[0]);
            fluxMessageChannel = channel;
        }
        return fluxMessageChannel;
    }
}

