/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.JsonMessageConverter;
import org.springframework.messaging.Message;

public class ByteArrayJsonMessageConverter
extends JsonMessageConverter {
    public ByteArrayJsonMessageConverter() {
    }

    public ByteArrayJsonMessageConverter(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    protected Object convertPayload(Message<?> message) {
        try {
            return this.getObjectMapper().writeValueAsBytes(message.getPayload());
        }
        catch (JsonProcessingException e) {
            throw new ConversionException("Failed to convert to JSON", message, (Throwable)e);
        }
    }
}

