/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.time.Duration;

public interface Acknowledgment {
    public void acknowledge();

    @Deprecated
    default public void nack(long sleepMillis) {
        this.nack(Duration.ofMillis(sleepMillis));
    }

    default public void nack(Duration sleep) {
        throw new UnsupportedOperationException("nack(sleep) is not supported by this Acknowledgment");
    }

    @Deprecated
    default public void nack(int index, long sleepMillis) {
        this.nack(index, Duration.ofMillis(sleepMillis));
    }

    default public void nack(int index, Duration sleep) {
        throw new UnsupportedOperationException("nack(index, sleep) is not supported by this Acknowledgment");
    }
}

