/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.List;
import java.util.concurrent.Executor;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.KafkaExceptionLogLevelAware;
import org.springframework.kafka.listener.ListenerUtils;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.util.Assert;

public class CommonContainerStoppingErrorHandler
extends KafkaExceptionLogLevelAware
implements CommonErrorHandler {
    private final Executor executor;
    private boolean stopContainerAbnormally = true;

    public CommonContainerStoppingErrorHandler() {
        this((Executor)new SimpleAsyncTaskExecutor("containerStop-"));
    }

    public CommonContainerStoppingErrorHandler(Executor executor) {
        Assert.notNull((Object)executor, (String)"'executor' cannot be null");
        this.executor = executor;
    }

    public void setStopContainerAbnormally(boolean stopContainerAbnormally) {
        this.stopContainerAbnormally = stopContainerAbnormally;
    }

    @Override
    public boolean seeksAfterHandling() {
        return true;
    }

    @Override
    public void handleOtherException(Exception thrownException, Consumer<?, ?> consumer, MessageListenerContainer container, boolean batchListener) {
        this.stopContainer(container, thrownException);
    }

    @Override
    public void handleRemaining(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        this.stopContainer(container, thrownException);
    }

    @Override
    public void handleBatch(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        this.stopContainer(container, thrownException);
    }

    private void stopContainer(MessageListenerContainer container, Exception thrownException) {
        this.executor.execute(() -> {
            if (this.stopContainerAbnormally) {
                container.stopAbnormally(() -> {});
            } else {
                container.stop(() -> {});
            }
        });
        try {
            ListenerUtils.stoppableSleep(container, 10000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        throw new KafkaException("Stopped container", this.getLogLevel(), thrownException);
    }
}

