/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.RetryTopicNamesProviderFactory;
import org.springframework.kafka.support.Suffixer;

public class SuffixingRetryTopicNamesProviderFactory
implements RetryTopicNamesProviderFactory {
    @Override
    public RetryTopicNamesProviderFactory.RetryTopicNamesProvider createRetryTopicNamesProvider(DestinationTopic.Properties properties) {
        return new SuffixingRetryTopicNamesProvider(properties);
    }

    public static class SuffixingRetryTopicNamesProvider
    implements RetryTopicNamesProviderFactory.RetryTopicNamesProvider {
        private final Suffixer suffixer;

        public SuffixingRetryTopicNamesProvider(DestinationTopic.Properties properties) {
            this.suffixer = new Suffixer(properties.suffix());
        }

        @Override
        public String getEndpointId(KafkaListenerEndpoint endpoint) {
            return this.suffixer.maybeAddTo(endpoint.getId());
        }

        @Override
        public String getGroupId(KafkaListenerEndpoint endpoint) {
            return this.suffixer.maybeAddTo(endpoint.getGroupId());
        }

        @Override
        public String getClientIdPrefix(KafkaListenerEndpoint endpoint) {
            return this.suffixer.maybeAddTo(endpoint.getClientIdPrefix());
        }

        @Override
        public String getGroup(KafkaListenerEndpoint endpoint) {
            return this.suffixer.maybeAddTo(endpoint.getGroup());
        }

        @Override
        public String getTopicName(String topic) {
            return this.suffixer.maybeAddTo(topic);
        }
    }
}

