/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class EndpointHandlerMethod {
    private final Object beanOrClass;
    private String methodName;
    private Object bean;
    private Method method;

    public EndpointHandlerMethod(Object beanOrClass, String methodName) {
        Assert.notNull((Object)beanOrClass, () -> "No destination bean or class provided!");
        Assert.notNull((Object)methodName, () -> "No method name for destination bean class provided!");
        this.beanOrClass = beanOrClass;
        this.methodName = methodName;
    }

    public EndpointHandlerMethod(Object bean) {
        Assert.notNull((Object)bean, () -> "No bean for destination provided!");
        this.bean = bean;
        this.beanOrClass = bean.getClass();
    }

    public EndpointHandlerMethod(Object bean, Method method) {
        Assert.notNull((Object)bean, () -> "No bean for destination provided!");
        Assert.notNull((Object)method, () -> "No method for destination bean class provided!");
        this.method = method;
        this.bean = bean;
        this.beanOrClass = bean.getClass();
        this.methodName = method.getName();
    }

    public Method getMethod() {
        Object object = this.beanOrClass;
        if (object instanceof Class) {
            Class clazz = (Class)object;
            return this.forClass(clazz);
        }
        Assert.state((this.bean != null ? 1 : 0) != 0, (String)"Bean must be resolved before accessing its method");
        if (this.bean instanceof EndpointHandlerMethod) {
            try {
                return Object.class.getMethod("toString", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        return this.forClass(this.bean.getClass());
    }

    public String getMethodName() {
        Assert.state((this.methodName != null ? 1 : 0) != 0, (String)"Unexpected call to getMethodName()");
        return this.methodName;
    }

    public Object resolveBean(BeanFactory beanFactory) {
        Object object = this.bean;
        if (object instanceof EndpointHandlerMethod) {
            EndpointHandlerMethod endpointHandlerMethod = (EndpointHandlerMethod)object;
            return endpointHandlerMethod.beanOrClass;
        }
        if (this.bean == null) {
            try {
                object = this.beanOrClass;
                if (object instanceof Class) {
                    Class clazz = (Class)object;
                    try {
                        this.bean = beanFactory.getBean(clazz);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        String beanName = clazz.getSimpleName() + "-handlerMethod";
                        ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(beanName, (BeanDefinition)new RootBeanDefinition(clazz));
                        this.bean = beanFactory.getBean(beanName);
                    }
                } else {
                    String beanName = (String)this.beanOrClass;
                    this.bean = beanFactory.getBean(beanName);
                }
            }
            catch (BeanCurrentlyInCreationException ex) {
                this.bean = this;
            }
        }
        return this.bean;
    }

    private Method forClass(Class<?> clazz) {
        if (this.method == null) {
            this.method = Arrays.stream(ReflectionUtils.getDeclaredMethods(clazz)).filter(mthd -> mthd.getName().equals(this.methodName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No method %s in class %s", this.methodName, clazz)));
        }
        return this.method;
    }
}

