/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.springframework.util.Assert;

public class ABSwitchCluster
implements Supplier<String> {
    private final AtomicBoolean which = new AtomicBoolean(true);
    private final String primary;
    private final String secondary;

    public ABSwitchCluster(String primary, String secondary) {
        Assert.hasText((String)primary, (String)"'primary' is required");
        Assert.hasText((String)secondary, (String)"'secondary' is required");
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public String get() {
        return this.which.get() ? this.primary : this.secondary;
    }

    public boolean isPrimary() {
        return this.which.get();
    }

    public void primary() {
        this.which.set(true);
    }

    public void secondary() {
        this.which.set(false);
    }
}

