/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.interceptor.SimpleTraceInterceptor;

public class DebugInterceptor
extends SimpleTraceInterceptor {
    private int count;

    public DebugInterceptor() {
    }

    public DebugInterceptor(boolean useDynamicLogger) {
        this.setUseDynamicLogger(useDynamicLogger);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        ++this.count;
        return super.invoke(invocation);
    }

    protected String getInvocationDescription(MethodInvocation invocation) {
        return invocation + "; count=" + this.count;
    }

    public int getCount() {
        return this.count;
    }

    public void resetCount() {
        this.count = 0;
    }
}

