/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.autoproxy;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.Assert;

public class BeanFactoryAdvisorRetrievalHelper {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$aop$framework$autoproxy$BeanFactoryAdvisorRetrievalHelper == null ? (class$org$springframework$aop$framework$autoproxy$BeanFactoryAdvisorRetrievalHelper = BeanFactoryAdvisorRetrievalHelper.class$("org.springframework.aop.framework.autoproxy.BeanFactoryAdvisorRetrievalHelper")) : class$org$springframework$aop$framework$autoproxy$BeanFactoryAdvisorRetrievalHelper));
    private final ConfigurableListableBeanFactory beanFactory;
    static /* synthetic */ Class class$org$springframework$aop$framework$autoproxy$BeanFactoryAdvisorRetrievalHelper;
    static /* synthetic */ Class class$org$springframework$aop$Advisor;
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanCurrentlyInCreationException;

    public BeanFactoryAdvisorRetrievalHelper(ConfigurableListableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"ListableBeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    public List findAdvisorBeans() {
        LinkedList<Object> advisors = new LinkedList<Object>();
        String[] advisorNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, (Class)(class$org$springframework$aop$Advisor == null ? (class$org$springframework$aop$Advisor = BeanFactoryAdvisorRetrievalHelper.class$("org.springframework.aop.Advisor")) : class$org$springframework$aop$Advisor), (boolean)true, (boolean)false);
        for (int i = 0; i < advisorNames.length; ++i) {
            String name = advisorNames[i];
            if (!this.isEligibleBean(name) || this.beanFactory.isCurrentlyInCreation(name)) continue;
            try {
                advisors.add(this.beanFactory.getBean(name));
                continue;
            }
            catch (BeanCreationException ex) {
                if (ex.contains(class$org$springframework$beans$factory$BeanCurrentlyInCreationException == null ? BeanFactoryAdvisorRetrievalHelper.class$("org.springframework.beans.factory.BeanCurrentlyInCreationException") : class$org$springframework$beans$factory$BeanCurrentlyInCreationException)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Ignoring currently created advisor '" + name + "': " + ex.getMessage()));
                    continue;
                }
                throw ex;
            }
        }
        return advisors;
    }

    protected boolean isEligibleBean(String beanName) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

