/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aspectj;

import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.aspectj.BeanWiringInfo;
import org.springframework.beans.factory.aspectj.BeanWiringInfoResolver;
import org.springframework.beans.factory.aspectj.ClassNameBeanWiringInfoResolver;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

@Aspect
public abstract class AbstractBeanConfigurer
implements BeanFactoryAware {
    private BeanWiringInfoResolver beanWiringInfoResolver = new ClassNameBeanWiringInfoResolver();
    private ConfigurableListableBeanFactory beanFactory;

    public void setBeanWiringInfoResolver(BeanWiringInfoResolver beanWiringInfoResolver) {
        this.beanWiringInfoResolver = beanWiringInfoResolver;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("Bean configurer aspect needs to run in a ConfigurableListableBeanFactory, not in [" + beanFactory + "]");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    protected void configureBean(Object bean, BeanWiringInfo bwi) {
        if (this.beanFactory == null) {
            throw new IllegalStateException("BeanFactory has not be set on aspect [" + this.getClass().getName() + "]: " + "This aspect should normally be added to a Spring container, for example in an XML bean definition");
        }
        if (bwi.indicatesAutowiring()) {
            this.beanFactory.autowireBeanProperties(bean, bwi.getAutowireMode(), bwi.getDependencyCheck());
        } else {
            this.beanFactory.applyBeanPropertyValues(bean, bwi.getBeanName());
        }
    }

    @Pointcut(value="", argNames="beanInstance")
    protected abstract void ajc$pointcut$$beanCreation$d09(Object var1);

    @AfterReturning(pointcut="beanCreation(beanInstance)", returning="", argNames="beanInstance")
    public void ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractBeanConfigurer$1$6b4509ab(Object beanInstance) {
        BeanWiringInfo bwi = this.beanWiringInfoResolver.resolveWiringInfo(beanInstance);
        if (bwi != null) {
            this.configureBean(beanInstance, bwi);
        }
    }
}

