/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aspectj;

import org.springframework.util.Assert;

public class BeanWiringInfo {
    int AUTOWIRE_BY_NAME = 1;
    int AUTOWIRE_BY_TYPE = 2;
    private String beanName = null;
    private int autowireMode = 0;
    private boolean dependencyCheck = false;

    public BeanWiringInfo(String beanName) {
        Assert.notNull((Object)beanName, (String)"Bean name must not be null");
        this.beanName = beanName;
    }

    public BeanWiringInfo(int autowireMode, boolean dependencyCheck) {
        this.autowireMode = autowireMode;
        this.dependencyCheck = dependencyCheck;
    }

    public boolean indicatesAutowiring() {
        return this.beanName == null;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public int getAutowireMode() {
        return this.autowireMode;
    }

    public boolean getDependencyCheck() {
        return this.dependencyCheck;
    }
}

