/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.staticmock;

import java.util.Arrays;
import java.util.LinkedList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.annotation.SuppressAjWarnings;
import org.aspectj.runtime.internal.AroundClosure;
import org.springframework.util.ObjectUtils;

@Deprecated
public abstract class AbstractMethodMockingControl {
    private final Expectations expectations = new Expectations();
    private boolean recording = true;

    protected void expectReturnInternal(Object retVal) {
        if (!this.recording) {
            throw new IllegalStateException("Not recording: Cannot set return value");
        }
        this.expectations.expectReturn(retVal);
    }

    protected void expectThrowInternal(Throwable throwable) {
        if (!this.recording) {
            throw new IllegalStateException("Not recording: Cannot set throwable value");
        }
        this.expectations.expectThrow(throwable);
    }

    protected void playbackInternal() {
        this.recording = false;
    }

    protected void verifyInternal() {
        this.expectations.verify();
    }

    protected void resetInternal() {
        this.expectations.reset();
        this.recording = true;
    }

    @Pointcut(value="", argNames="")
    protected abstract /* synthetic */ void ajc$pointcut$$mockStaticsTestMethod$16c1();

    @Pointcut(value="", argNames="")
    protected abstract /* synthetic */ void ajc$pointcut$$methodToMock$1741();

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @AfterReturning(pointcut="mockStaticsTestMethod()", returning="", argNames="")
    public void ajc$afterReturning$org_springframework_mock_staticmock_AbstractMethodMockingControl$1$94476acf() {
        if (this.recording && this.expectations.hasCalls()) {
            throw new IllegalStateException("Calls have been recorded, but playback state was never reached. Set expectations and then call " + this.getClass().getSimpleName() + ".playback();");
        }
        this.verifyInternal();
    }

    @SuppressAjWarnings(value={"adviceDidNotMatch"})
    @Around(value="(methodToMock() && cflowbelow(mockStaticsTestMethod()))", argNames="ajc$aroundClosure")
    public Object ajc$around$org_springframework_mock_staticmock_AbstractMethodMockingControl$2$9cfbb496(AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart, JoinPoint thisJoinPoint) {
        if (this.recording) {
            this.expectations.expectCall(thisJoinPointStaticPart.toLongString(), thisJoinPoint.getArgs());
            return null;
        }
        return this.expectations.respond(thisJoinPointStaticPart.toLongString(), thisJoinPoint.getArgs());
    }

    static /* synthetic */ Object ajc$around$org_springframework_mock_staticmock_AbstractMethodMockingControl$2$9cfbb496proceed(AroundClosure this_) throws Throwable {
        return this_.run(new Object[0]);
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_springframework_mock_staticmock_AbstractMethodMockingControl$org_springframework_mock_staticmock_AbstractMethodMockingControl$recording(AbstractMethodMockingControl abstractMethodMockingControl, boolean bl) {
        abstractMethodMockingControl.recording = bl;
    }

    public static /* synthetic */ void ajc$inlineAccessFieldSet$org_springframework_mock_staticmock_AbstractMethodMockingControl$org_springframework_mock_staticmock_AbstractMethodMockingControl$expectations(AbstractMethodMockingControl abstractMethodMockingControl, Expectations expectations) {
        abstractMethodMockingControl.expectations = expectations;
    }

    private static enum CallResponse {
        undefined,
        return_,
        throw_;

    }

    public class Expectations {
        private final LinkedList<Call> calls = new LinkedList();
        private int verified;

        public void verify() {
            if (this.verified != this.calls.size()) {
                throw new IllegalStateException("Expected " + this.calls.size() + " calls, but received " + this.verified);
            }
        }

        public Object respond(String lastSig, Object[] args) {
            Call c = this.nextCall();
            switch (c.responseType) {
                case return_: {
                    return c.returnValue(lastSig, args);
                }
                case throw_: {
                    return c.throwException(lastSig, args);
                }
            }
            throw new IllegalStateException("Behavior of " + c + " not specified");
        }

        private Call nextCall() {
            ++this.verified;
            if (this.verified > this.calls.size()) {
                throw new IllegalStateException("Expected " + this.calls.size() + " calls, but received " + this.verified);
            }
            return this.calls.get(this.verified - 1);
        }

        public void expectCall(String lastSig, Object[] lastArgs) {
            this.calls.add(new Call(lastSig, lastArgs));
        }

        public boolean hasCalls() {
            return !this.calls.isEmpty();
        }

        public void expectReturn(Object retVal) {
            Call c = this.calls.getLast();
            if (c.responseTypeAlreadySet()) {
                throw new IllegalStateException("No method invoked before setting return value");
            }
            c.setReturnValue(retVal);
        }

        public void expectThrow(Throwable throwable) {
            Call c = this.calls.getLast();
            if (c.responseTypeAlreadySet()) {
                throw new IllegalStateException("No method invoked before setting throwable");
            }
            c.setThrowable(throwable);
        }

        public void reset() {
            this.calls.clear();
            this.verified = 0;
        }

        private class Call {
            private final String signature;
            private final Object[] args;
            private CallResponse responseType = CallResponse.undefined;
            private Object responseObject;

            Call(String signature, Object[] args) {
                this.signature = signature;
                this.args = args;
            }

            boolean responseTypeAlreadySet() {
                return this.responseType != CallResponse.undefined;
            }

            void setReturnValue(Object retVal) {
                this.responseObject = retVal;
                this.responseType = CallResponse.return_;
            }

            void setThrowable(Throwable throwable) {
                this.responseObject = throwable;
                this.responseType = CallResponse.throw_;
            }

            Object returnValue(String lastSig, Object[] args) {
                this.checkSignature(lastSig, args);
                return this.responseObject;
            }

            Object throwException(String lastSig, Object[] args) {
                this.checkSignature(lastSig, args);
                throw (RuntimeException)this.responseObject;
            }

            private void checkSignature(String lastSig, Object[] args) {
                if (!this.signature.equals(lastSig)) {
                    throw new IllegalArgumentException("Signatures do not match");
                }
                if (!Arrays.equals(this.args, args)) {
                    throw new IllegalArgumentException("Arguments do not match");
                }
            }

            public String toString() {
                return String.format("Call with signature [%s] and arguments %s", this.signature, ObjectUtils.nullSafeToString((Object[])this.args));
            }
        }
    }
}

