/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework.support;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.AspectException;
import org.springframework.aop.Advisor;
import org.springframework.aop.InterceptionAroundAdvisor;
import org.springframework.aop.InterceptionIntroductionAdvisor;
import org.springframework.aop.Pointcut;

public abstract class AopUtils {
    public static boolean isCglibProxy(Object o) {
        return o.getClass().getName().indexOf("$$") != -1;
    }

    public static boolean isJdkDynamicProxy(Object o) {
        return Proxy.isProxyClass(o.getClass());
    }

    public static boolean isAopProxy(Object o) {
        return AopUtils.isJdkDynamicProxy(o) || AopUtils.isCglibProxy(o);
    }

    public static Method getMostSpecificMethod(Method method, Class targetClass) {
        if (targetClass != null) {
            try {
                method = targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }

    public static Class[] toInterfaceArray(String[] interfaceNames) throws AspectException, ClassNotFoundException {
        Class[] interfaces = new Class[interfaceNames.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            interfaces[i] = Class.forName(interfaceNames[i], true, Thread.currentThread().getContextClassLoader());
            if (interfaces[i].isInterface()) continue;
            throw new AspectException("Can proxy only interfaces: " + interfaces[i] + " is a class");
        }
        return interfaces;
    }

    public static Class[] getAllInterfaces(Object object) {
        List interfaces = AopUtils.getAllInterfacesAsList(object);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static List getAllInterfacesAsList(Object object) {
        ArrayList interfaces = new ArrayList();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (int i = 0; i < clazz.getInterfaces().length; ++i) {
                Class<?> ifc = clazz.getInterfaces()[i];
                interfaces.add(ifc);
            }
        }
        return interfaces;
    }

    public static boolean methodIsOnOneOfTheseInterfaces(Method m, Class[] interfaces) {
        if (interfaces == null) {
            return false;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].isInterface()) {
                throw new IllegalArgumentException(interfaces[i].getName() + " is not an interface");
            }
            try {
                interfaces[i].getDeclaredMethod(m.getName(), m.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return false;
    }

    public static boolean canApply(Pointcut pc, Class targetClass, Class[] proxyInterfaces) {
        if (!pc.getClassFilter().matches(targetClass)) {
            return false;
        }
        Method[] methods = targetClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (proxyInterfaces != null && !AopUtils.methodIsOnOneOfTheseInterfaces(m, proxyInterfaces) || !pc.getMethodMatcher().matches(m, targetClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean canApply(Advisor advice, Class targetClass, Class[] proxyInterfaces) {
        if (advice instanceof InterceptionIntroductionAdvisor) {
            return ((InterceptionIntroductionAdvisor)advice).getClassFilter().matches(targetClass);
        }
        InterceptionAroundAdvisor interceptionAdvice = (InterceptionAroundAdvisor)advice;
        return AopUtils.canApply(interceptionAdvice.getPointcut(), targetClass, proxyInterfaces);
    }
}

