/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.velocity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.core.io.Resource;
import org.springframework.ui.velocity.CommonsLoggingLogSystem;
import org.springframework.ui.velocity.VelocityInitializationException;

public class VelocityEngineFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private Properties velocityProperties;
    private Resource resourceLoaderPath;
    private boolean overrideLogging = true;
    private VelocityEngine velocityEngine;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setVelocityProperties(Properties velocityProperties) {
        this.velocityProperties = velocityProperties;
    }

    public void setResourceLoaderPath(Resource resourceLoaderPath) {
        this.resourceLoaderPath = resourceLoaderPath;
    }

    public void setOverrideLogging(boolean overrideLogging) {
        this.overrideLogging = overrideLogging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initVelocityEngine() throws VelocityInitializationException {
        Properties props;
        block14: {
            this.velocityEngine = this.newVelocityEngine();
            props = new Properties();
            try {
                Resource actualLocation = this.configLocation;
                if (this.configLocation == null && this.velocityProperties == null && this.resourceLoaderPath == null) {
                    actualLocation = this.getDefaultConfigLocation();
                }
                if (actualLocation == null) break block14;
                this.logger.info((Object)("Loading Velocity config from [" + actualLocation + "]"));
                InputStream is = actualLocation.getInputStream();
                try {
                    props.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ex) {
                throw new VelocityInitializationException("Error loading Velocity config from [" + this.configLocation + "]", ex);
            }
        }
        if (this.velocityProperties != null) {
            props.putAll((Map<?, ?>)this.velocityProperties);
        }
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.velocityEngine.setProperty(key, (Object)props.getProperty(key));
        }
        try {
            if (this.resourceLoaderPath != null) {
                if (!this.resourceLoaderPath.exists()) {
                    throw new VelocityInitializationException("Specified resource loader path does not exist: " + this.resourceLoaderPath);
                }
                this.velocityEngine.setProperty("file.resource.loader.path", (Object)this.resourceLoaderPath.getFile().getAbsolutePath());
            }
            if (this.overrideLogging) {
                this.velocityEngine.setProperty("runtime.log.logsystem", (Object)new CommonsLoggingLogSystem());
            }
            this.velocityEngine.init();
        }
        catch (VelocityInitializationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new VelocityInitializationException("Could not initialize Velocity engine", ex);
        }
    }

    protected Resource getDefaultConfigLocation() throws IOException {
        return null;
    }

    protected VelocityEngine newVelocityEngine() {
        return new VelocityEngine();
    }

    public synchronized VelocityEngine getVelocityEngine() throws VelocityInitializationException {
        if (this.velocityEngine == null) {
            this.initVelocityEngine();
        }
        return this.velocityEngine;
    }
}

