/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public abstract class AbstractMessageSource
implements HierarchicalMessageSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MessageSource parentMessageSource;
    private boolean useCodeAsDefaultMessage = false;

    public void setParentMessageSource(MessageSource parent) {
        this.parentMessageSource = parent;
    }

    public MessageSource getParentMessageSource() {
        return this.parentMessageSource;
    }

    public void setUseCodeAsDefaultMessage(boolean useCodeAsDefaultMessage) {
        this.useCodeAsDefaultMessage = useCodeAsDefaultMessage;
    }

    public final String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String msg = this.getMessageInternal(code, args, locale);
        if (msg != null) {
            return msg;
        }
        if (this.parentMessageSource != null) {
            return this.parentMessageSource.getMessage(code, args, defaultMessage, locale);
        }
        if (defaultMessage == null && this.useCodeAsDefaultMessage) {
            return code;
        }
        return defaultMessage;
    }

    public final String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        String msg = this.getMessageInternal(code, args, locale);
        if (msg != null) {
            return msg;
        }
        if (this.parentMessageSource != null) {
            return this.parentMessageSource.getMessage(code, args, locale);
        }
        if (this.useCodeAsDefaultMessage) {
            return code;
        }
        throw new NoSuchMessageException(code, locale);
    }

    public final String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        String[] codes = resolvable.getCodes();
        if (codes == null) {
            throw new NoSuchMessageException(null, locale);
        }
        for (int i = 0; i < codes.length; ++i) {
            String msg = this.getMessageInternal(codes[i], resolvable.getArguments(), locale);
            if (msg == null) continue;
            return msg;
        }
        if (this.parentMessageSource != null) {
            return this.parentMessageSource.getMessage(resolvable, locale);
        }
        if (resolvable.getDefaultMessage() != null) {
            return resolvable.getDefaultMessage();
        }
        if (this.useCodeAsDefaultMessage && codes.length > 0) {
            return codes[0];
        }
        throw new NoSuchMessageException(codes.length > 0 ? codes[codes.length - 1] : null, locale);
    }

    protected String getMessageInternal(String code, Object[] args, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (code == null) {
            return null;
        }
        MessageFormat messageFormat = this.resolveCode(code, locale);
        if (messageFormat != null) {
            return messageFormat.format(this.resolveArguments(args, locale));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Could not resolve message code [" + code + "] in locale [" + locale + "]"));
        }
        return null;
    }

    private Object[] resolveArguments(Object[] args, Locale locale) {
        if (args == null) {
            return new Object[0];
        }
        ArrayList<Object> resolvedArgs = new ArrayList<Object>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof MessageSourceResolvable) {
                resolvedArgs.add(this.getMessage((MessageSourceResolvable)args[i], locale));
                continue;
            }
            resolvedArgs.add(args[i]);
        }
        return resolvedArgs.toArray(new Object[resolvedArgs.size()]);
    }

    protected abstract MessageFormat resolveCode(String var1, Locale var2);
}

