/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.quartz.JobPersistenceException;
import org.quartz.SchedulerConfigException;
import org.quartz.impl.jdbcjobstore.JobStoreCMT;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class LocalDataSourceJobStore
extends JobStoreCMT {
    protected static ThreadLocal configTimeDataSourceHolder = new ThreadLocal();
    private DataSource dataSource;

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        this.setDataSource("dummy");
        this.setNonManagedTXDataSource("dummy");
        this.dataSource = (DataSource)configTimeDataSourceHolder.get();
        if (this.dataSource == null) {
            throw new SchedulerConfigException("No local DataSource found for configuration - dataSource property must be set on SchedulerFactoryBean");
        }
        super.initialize(loadHelper, signaler);
    }

    protected Connection getConnection() {
        return DataSourceUtils.getConnection((DataSource)this.dataSource);
    }

    protected Connection getNonManagedTXConnection() throws JobPersistenceException {
        Connection con = DataSourceUtils.getConnection((DataSource)this.dataSource);
        try {
            if (!this.isDontSetNonManagedTXConnectionAutoCommitFalse()) {
                con.setAutoCommit(false);
            }
            if (this.isTxIsolationLevelReadCommitted()) {
                con.setTransactionIsolation(1);
            }
        }
        catch (SQLException ex) {
            throw new JobPersistenceException("Failed to prepare JDBC connection", (Exception)ex);
        }
        return con;
    }

    protected void closeConnection(Connection con) {
        DataSourceUtils.closeConnectionIfNecessary((Connection)con, (DataSource)this.dataSource);
    }
}

