/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.StringUtils;
import org.springframework.validation.MessageCodesResolver;

public class DefaultMessageCodesResolver
implements MessageCodesResolver,
Serializable {
    public static final String CODE_SEPARATOR = ".";

    public String[] resolveMessageCodes(String errorCode, String objectName) {
        return new String[]{errorCode + CODE_SEPARATOR + objectName, errorCode};
    }

    public String[] resolveMessageCodes(String errorCode, String objectName, String field, Class fieldType) {
        ArrayList<String> codeList = new ArrayList<String>();
        ArrayList fieldList = new ArrayList();
        this.buildFieldList(field, fieldList);
        Iterator it = fieldList.iterator();
        while (it.hasNext()) {
            String fieldInList = (String)it.next();
            codeList.add(errorCode + CODE_SEPARATOR + objectName + CODE_SEPARATOR + fieldInList);
        }
        int dotIndex = field.lastIndexOf(46);
        if (dotIndex != -1) {
            this.buildFieldList(field.substring(dotIndex + 1), fieldList);
        }
        Iterator it2 = fieldList.iterator();
        while (it2.hasNext()) {
            String fieldInList = (String)it2.next();
            codeList.add(errorCode + CODE_SEPARATOR + fieldInList);
        }
        if (fieldType != null) {
            codeList.add(errorCode + CODE_SEPARATOR + fieldType.getName());
        }
        codeList.add(errorCode);
        return StringUtils.toStringArray(codeList);
    }

    protected void buildFieldList(String field, List fieldList) {
        fieldList.add(field);
        String plainField = field;
        int keyIndex = plainField.lastIndexOf(91);
        while (keyIndex != -1) {
            int endKeyIndex = plainField.indexOf(93, keyIndex);
            if (endKeyIndex != -1) {
                plainField = plainField.substring(0, keyIndex) + plainField.substring(endKeyIndex + 1);
                fieldList.add(plainField);
                keyIndex = plainField.lastIndexOf(91);
                continue;
            }
            keyIndex = -1;
        }
    }
}

