/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.transaction.config.TxNamespaceHandler;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class TxAdviceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ATTRIBUTES = "attributes";
    public static final String TIMEOUT = "timeout";
    public static final String READ_ONLY = "read-only";
    public static final String NAME_MAP = "nameMap";
    public static final String PROPAGATION = "propagation";
    public static final String ISOLATION = "isolation";
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionInterceptor;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource;

    TxAdviceBeanDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        return class$org$springframework$transaction$interceptor$TransactionInterceptor == null ? (class$org$springframework$transaction$interceptor$TransactionInterceptor = TxAdviceBeanDefinitionParser.class$("org.springframework.transaction.interceptor.TransactionInterceptor")) : class$org$springframework$transaction$interceptor$TransactionInterceptor;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        builder.addPropertyReference("transactionManager", element.getAttribute("transactionManager"));
        List txAttributes = DomUtils.getChildElementsByTagName((Element)element, (String)ATTRIBUTES, (boolean)true);
        if (txAttributes.size() > 1) {
            throw new IllegalStateException("Element 'attributes' is allowed at most once inside element 'advice'");
        }
        if (txAttributes.size() == 1) {
            this.parseAttributes((Element)txAttributes.get(0), builder);
        } else {
            builder.addPropertyValue("transactionAttributeSource", (Object)new RootBeanDefinition(TxNamespaceHandler.getAnnotationSourceClass()));
        }
    }

    private void parseAttributes(Element attributesElement, BeanDefinitionBuilder builder) {
        List methods = DomUtils.getChildElementsByTagName((Element)attributesElement, (String)"method", (boolean)true);
        HashMap<String, RuleBasedTransactionAttribute> transactionAttributeMap = new HashMap<String, RuleBasedTransactionAttribute>(methods.size());
        for (int i = 0; i < methods.size(); ++i) {
            Element methodElement = (Element)methods.get(i);
            String name = methodElement.getAttribute("name");
            RuleBasedTransactionAttribute attribute = new RuleBasedTransactionAttribute();
            attribute.setPropagationBehaviorName("PROPAGATION_" + methodElement.getAttribute(PROPAGATION));
            attribute.setIsolationLevelName("ISOLATION_" + methodElement.getAttribute(ISOLATION));
            attribute.setTimeout(Integer.parseInt(methodElement.getAttribute(TIMEOUT)));
            attribute.setReadOnly(Boolean.valueOf(methodElement.getAttribute(READ_ONLY)));
            transactionAttributeMap.put(name, attribute);
        }
        RootBeanDefinition attributeSourceDefinition = new RootBeanDefinition(class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource == null ? (class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource = TxAdviceBeanDefinitionParser.class$("org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource")) : class$org$springframework$transaction$interceptor$NameMatchTransactionAttributeSource);
        attributeSourceDefinition.setPropertyValues(new MutablePropertyValues());
        attributeSourceDefinition.getPropertyValues().addPropertyValue(NAME_MAP, transactionAttributeMap);
        builder.addPropertyValue("transactionAttributeSource", (Object)attributeSourceDefinition);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

