/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import org.springframework.aop.config.NamespaceHandlerUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.transaction.config.TxAdviceBeanDefinitionParser;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public class TxNamespaceHandler
extends NamespaceHandlerSupport {
    public static final String TRANSACTION_MANAGER = "transactionManager";
    public static final String TRANSACTION_ATTRIBUTE_SOURCE = "transactionAttributeSource";
    public static final String ANNOTATION_SOURCE_CLASS_NAME = "org.springframework.transaction.annotation.AnnotationTransactionAttributeSource";
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionInterceptor;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor;

    public TxNamespaceHandler() {
        this.registerBeanDefinitionParser("advice", (BeanDefinitionParser)new TxAdviceBeanDefinitionParser());
        this.registerBeanDefinitionParser("annotation-driven", new AnnotationDrivenBeanDefinitionParser());
    }

    public static Class getAnnotationSourceClass() {
        try {
            return ClassUtils.forName((String)ANNOTATION_SOURCE_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to locate AnnotationTransactionAttributeSource. Are you running on Java 1.5?");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AnnotationDrivenBeanDefinitionParser
    implements BeanDefinitionParser {
        private static final String TRANSACTION_ATTRIBUTE_SOURCE_ADVISOR_NAME = ".transactionAttributeSourceAdvisor";
        public static final String TRANSACTION_INTERCEPTOR = "transactionInterceptor";

        private AnnotationDrivenBeanDefinitionParser() {
        }

        public void parse(Element element, BeanDefinitionRegistry registry) {
            NamespaceHandlerUtils.registerAutoProxyCreatorIfNecessary((BeanDefinitionRegistry)registry);
            String transactionManagerName = element.getAttribute(TxNamespaceHandler.TRANSACTION_MANAGER);
            RootBeanDefinition interceptorDefinition = new RootBeanDefinition(class$org$springframework$transaction$interceptor$TransactionInterceptor == null ? (class$org$springframework$transaction$interceptor$TransactionInterceptor = TxNamespaceHandler.class$("org.springframework.transaction.interceptor.TransactionInterceptor")) : class$org$springframework$transaction$interceptor$TransactionInterceptor);
            interceptorDefinition.setPropertyValues(new MutablePropertyValues());
            interceptorDefinition.getPropertyValues().addPropertyValue(TxNamespaceHandler.TRANSACTION_MANAGER, (Object)new RuntimeBeanReference(transactionManagerName));
            interceptorDefinition.getPropertyValues().addPropertyValue(TxNamespaceHandler.TRANSACTION_ATTRIBUTE_SOURCE, (Object)new RootBeanDefinition(TxNamespaceHandler.getAnnotationSourceClass()));
            RootBeanDefinition advisorDefinition = new RootBeanDefinition(class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor == null ? (class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor = TxNamespaceHandler.class$("org.springframework.transaction.interceptor.TransactionAttributeSourceAdvisor")) : class$org$springframework$transaction$interceptor$TransactionAttributeSourceAdvisor);
            advisorDefinition.setPropertyValues(new MutablePropertyValues());
            advisorDefinition.getPropertyValues().addPropertyValue(TRANSACTION_INTERCEPTOR, (Object)interceptorDefinition);
            registry.registerBeanDefinition(TRANSACTION_ATTRIBUTE_SOURCE_ADVISOR_NAME, (BeanDefinition)advisorDefinition);
        }
    }
}

