/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.mock.web.DelegatingServletInputStream;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockRequestDispatcher;
import org.springframework.mock.web.MockServletContext;

public class MockHttpServletRequest
implements HttpServletRequest,
Serializable {
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_SERVER_NAME = "localhost";
    public static final int DEFAULT_SERVER_PORT = 80;
    public static final String DEFAULT_REMOTE_ADDR = "127.0.0.1";
    public static final String DEFAULT_REMOTE_HOST = "localhost";
    private final Hashtable attributes = new Hashtable();
    private String characterEncoding;
    private byte[] content;
    private String contentType;
    private final Hashtable parameters = new Hashtable();
    private String protocol = "http";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 80;
    private String remoteAddr = "127.0.0.1";
    private String remoteHost = "localhost";
    private final Vector locales = new Vector();
    private boolean secure = false;
    private final ServletContext servletContext;
    private String authType;
    private Cookie[] cookies;
    private final Hashtable headers = new Hashtable();
    private String method;
    private String pathInfo;
    private String contextPath = "";
    private String queryString;
    private String remoteUser;
    private final Set roles = new HashSet();
    private Principal userPrincipal;
    private String requestURI = "";
    private String servletPath = "";
    private HttpSession session;
    private boolean requestedSessionIdValid = true;
    private boolean requestedSessionIdFromCookie = true;
    private boolean requestedSessionIdFromURL = false;

    public MockHttpServletRequest(ServletContext servletContext) {
        this.locales.add(Locale.ENGLISH);
        this.servletContext = servletContext;
    }

    public MockHttpServletRequest(ServletContext servletContext, String method, String requestURI) {
        this(servletContext);
        this.method = method;
        this.requestURI = requestURI;
    }

    public MockHttpServletRequest() {
        this(new MockServletContext());
    }

    public MockHttpServletRequest(String method, String requestURI) {
        this(new MockServletContext(), method, requestURI);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public int getContentLength() {
        return this.content != null ? this.content.length : -1;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() {
        if (this.content != null) {
            return new DelegatingServletInputStream(new ByteArrayInputStream(this.content));
        }
        return null;
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void addParameter(String name, String[] values) {
        this.parameters.put(name, values);
    }

    public String getParameter(String name) {
        Object obj = this.parameters.get(name);
        if (obj instanceof String[]) {
            String[] arr = (String[])obj;
            return arr.length > 0 ? arr[0] : null;
        }
        return obj != null ? obj.toString() : null;
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public String[] getParameterValues(String name) {
        String[] stringArray;
        Object obj = this.parameters.get(name);
        if (obj instanceof String[]) {
            return (String[])obj;
        }
        if (obj != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = obj.toString();
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public Map getParameterMap() {
        return new HashMap(this.parameters);
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this.content != null) {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.content);
            InputStreamReader sourceReader = this.characterEncoding != null ? new InputStreamReader((InputStream)sourceStream, this.characterEncoding) : new InputStreamReader(sourceStream);
            return new BufferedReader(sourceReader);
        }
        return null;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void addPreferredLocale(Locale locale) {
        this.locales.add(0, locale);
    }

    public Locale getLocale() {
        return (Locale)this.locales.get(0);
    }

    public Enumeration getLocales() {
        return this.locales.elements();
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void addHeader(String name, Object value) {
        this.headers.put(name, value);
    }

    public long getDateHeader(String name) {
        Object value = this.headers.get(name);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return -1L;
    }

    public String getHeader(String name) {
        Object value = this.headers.get(name);
        return value != null ? value.toString() : null;
    }

    public Enumeration getHeaders(String name) {
        Object obj = this.headers.get(name);
        if (obj instanceof String[]) {
            return Collections.enumeration(Arrays.asList((String[])obj));
        }
        Vector<String> vector = new Vector<String>();
        vector.add(obj.toString());
        return vector.elements();
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public int getIntHeader(String name) {
        Object value = this.headers.get(name);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return -1;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathInfo != null ? this.getRealPath(this.pathInfo) : null;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getRequestedSessionId() {
        HttpSession session = this.getSession();
        return session != null ? session.getId() : null;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer(this.scheme);
        url.append("://").append(this.serverName).append(':').append(this.serverPort);
        url.append(this.getRequestURI());
        return url;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setSession(HttpSession session) {
        this.session = session;
        if (session instanceof MockHttpSession) {
            MockHttpSession mockSession = (MockHttpSession)session;
            mockSession.access();
        }
    }

    public HttpSession getSession(boolean create) {
        if (this.session == null && create) {
            this.session = new MockHttpSession(this.servletContext);
        }
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public void setRequestedSessionIdValid(boolean requestedSessionIdValid) {
        this.requestedSessionIdValid = requestedSessionIdValid;
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public void setRequestedSessionIdFromCookie(boolean requestedSessionIdFromCookie) {
        this.requestedSessionIdFromCookie = requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie;
    }

    public void setRequestedSessionIdFromURL(boolean requestedSessionIdFromURL) {
        this.requestedSessionIdFromURL = requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }
}

