/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.springframework.mock.web.DelegatingServletOutputStream;

public class MockHttpServletResponse
implements HttpServletResponse {
    public static final int DEFAULT_SERVER_PORT = 80;
    private String characterEncoding;
    private final ByteArrayOutputStream content = new ByteArrayOutputStream();
    private final DelegatingServletOutputStream outputStream = new DelegatingServletOutputStream(this.content);
    private PrintWriter writer;
    private int contentLength = 0;
    private String contentType;
    private int bufferSize = 4096;
    private boolean committed;
    private Locale locale = Locale.getDefault();
    private final List cookies = new ArrayList();
    private final Hashtable headers = new Hashtable();
    private int status = 200;
    private String errorMessage;
    private String redirectedUrl;
    private String forwardedUrl;
    private String includedUrl;

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ServletOutputStream getOutputStream() {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            OutputStreamWriter targetWriter = this.characterEncoding != null ? new OutputStreamWriter((OutputStream)this.content, this.characterEncoding) : new OutputStreamWriter(this.content);
            this.writer = new PrintWriter(targetWriter);
        }
        return this.writer;
    }

    public byte[] getContentAsByteArray() {
        return this.content.toByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        return this.characterEncoding != null ? this.content.toString(this.characterEncoding) : this.content.toString();
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() {
        if (this.committed) {
            throw new IllegalStateException("Cannot flush buffer - response is already committed");
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not flush OutputStream: " + ex.getMessage());
            }
        }
        if (this.writer != null) {
            this.writer.flush();
        }
        this.committed = true;
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
        this.content.reset();
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        this.resetBuffer();
        this.characterEncoding = null;
        this.contentLength = 0;
        this.contentType = null;
        this.locale = null;
        this.cookies.clear();
        this.headers.clear();
        this.status = 200;
        this.errorMessage = null;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public boolean containsHeader(String name) {
        return this.headers.contains(name);
    }

    public Object getHeader(String name) {
        return this.headers.get(name);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public void sendError(int status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public void sendError(int status) {
        this.status = status;
    }

    public void sendRedirect(String url) {
        this.redirectedUrl = url;
    }

    public String getRedirectedUrl() {
        return this.redirectedUrl;
    }

    public void setDateHeader(String name, long value) {
        this.headers.put(name, new Long(value));
    }

    public void addDateHeader(String name, long value) {
        this.headers.put(name, new Long(value));
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.put(name, new Integer(value));
    }

    public void addIntHeader(String name, int value) {
        this.headers.put(name, new Integer(value));
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setForwardedUrl(String forwardedUrl) {
        this.forwardedUrl = forwardedUrl;
    }

    public String getForwardedUrl() {
        return this.forwardedUrl;
    }

    public void setIncludedUrl(String includedUrl) {
        this.includedUrl = includedUrl;
    }

    public String getIncludedUrl() {
        return this.includedUrl;
    }
}

