/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbstractModelAndViewTests
extends TestCase {
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Object;

    protected void assertModelAttributeAvailable(ModelAndView mav, Object key) {
        AbstractModelAndViewTests.assertNotNull((String)"Model is null", (Object)mav.getModel());
        AbstractModelAndViewTests.assertTrue((String)("Model attribute with name '" + key + "' is not available"), (boolean)mav.getModel().containsKey(key));
    }

    protected void assertCompareListModelAttribute(ModelAndView mav, Object key, List assertionList) {
        List modelList = (List)this.assertAndReturnModelAttributeOfType(mav, key, class$java$util$List == null ? (class$java$util$List = AbstractModelAndViewTests.class$("java.util.List")) : class$java$util$List);
        AbstractModelAndViewTests.assertEquals((String)("Size of model list is '" + modelList.size() + "' while size of assertion list is '" + assertionList.size() + "'"), (int)assertionList.size(), (int)modelList.size());
        AbstractModelAndViewTests.assertEquals((String)("List in model under key '" + key + "' is not equals to given list"), (Object)assertionList, (Object)modelList);
    }

    protected void assertSortAndCompareListModelAttribute(ModelAndView mav, Object key, List assertionList, Comparator comp) {
        List modelList = (List)this.assertAndReturnModelAttributeOfType(mav, key, class$java$util$List == null ? (class$java$util$List = AbstractModelAndViewTests.class$("java.util.List")) : class$java$util$List);
        AbstractModelAndViewTests.assertEquals((String)("Size of model list is '" + modelList.size() + "' while size of assertion list is '" + assertionList.size() + "'"), (int)assertionList.size(), (int)modelList.size());
        if (comp != null) {
            Collections.sort(modelList, comp);
            Collections.sort(assertionList, comp);
        } else {
            Collections.sort(modelList);
            Collections.sort(assertionList);
        }
        AbstractModelAndViewTests.assertEquals((String)("List in model under key '" + key + "' is not equals to given list"), (Object)assertionList, (Object)modelList);
    }

    protected Object assertAndReturnModelAttributeOfType(ModelAndView mav, Object key, Class type) {
        AbstractModelAndViewTests.assertNotNull((String)"Model is null", (Object)mav.getModel());
        AbstractModelAndViewTests.assertNotNull((String)("Model attribute with key '" + key + "' is null"), mav.getModel().get(key));
        Object obj = mav.getModel().get(key);
        AbstractModelAndViewTests.assertTrue((String)("Model attribute is not of type '" + type.getName() + "' but is a '" + obj.getClass().getName() + "'"), (boolean)type.isAssignableFrom(obj.getClass()));
        return obj;
    }

    protected void assertViewName(ModelAndView mav, String name) {
        AbstractModelAndViewTests.assertEquals((String)("View name is not equal to '" + name + "' but was '" + mav.getViewName() + "'"), (String)name, (String)mav.getViewName());
    }

    protected void assertModelAttributeValue(ModelAndView mav, Object key, Object value) {
        Object modelValue = this.assertAndReturnModelAttributeOfType(mav, key, class$java$lang$Object == null ? (class$java$lang$Object = AbstractModelAndViewTests.class$("java.lang.Object")) : class$java$lang$Object);
        AbstractModelAndViewTests.assertEquals((String)("Model value with key '" + key + "' is not the same as given value which was '" + value + "'"), (Object)value, (Object)modelValue);
    }

    protected void assertModelAttributeValues(ModelAndView mav, Map assertionModel) {
        StringBuffer buf;
        AbstractModelAndViewTests.assertNotNull((Object)mav.getModel());
        if (!((Object)mav.getModel().keySet()).equals(assertionModel.keySet())) {
            buf = new StringBuffer("Keyset of given model does not match.\n");
            this.appendNonMatchingSetsErrorMessage(assertionModel.keySet(), mav.getModel().keySet(), buf);
            AbstractModelAndViewTests.fail((String)buf.toString());
        }
        buf = new StringBuffer();
        Iterator it = mav.getModel().keySet().iterator();
        while (it.hasNext()) {
            Object mavValue;
            Object key = it.next();
            Object assertionValue = assertionModel.get(key);
            if (assertionValue.equals(mavValue = mav.getModel().get(key))) continue;
            buf.append("Value under key '" + key + "' differs, should have been '" + assertionValue + "' but was '" + mavValue + "'\n");
        }
        if (buf.length() != 0) {
            buf.insert(0, "Values of given model do not match.\n");
            AbstractModelAndViewTests.fail((String)buf.toString());
        }
    }

    private void appendNonMatchingSetsErrorMessage(Set assertionSet, Set incorrectSet, StringBuffer buf) {
        Object o;
        Iterator it;
        HashSet tempSet = new HashSet();
        tempSet.addAll(incorrectSet);
        tempSet.removeAll(assertionSet);
        if (tempSet.size() > 0) {
            buf.append("Set has too many elements:\n");
            it = tempSet.iterator();
            while (it.hasNext()) {
                o = it.next();
                buf.append('-');
                buf.append(o.toString());
                buf.append('\n');
            }
        }
        tempSet = new HashSet();
        tempSet.addAll(assertionSet);
        tempSet.removeAll(incorrectSet);
        if (tempSet.size() > 0) {
            buf.append("Set is missing elements:\n");
            it = tempSet.iterator();
            while (it.hasNext()) {
                o = it.next();
                buf.append('-');
                buf.append(o.toString());
                buf.append('\n');
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

