/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenSessionInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private String sessionFactoryBeanName = "sessionFactory";
    private boolean singleSession = true;

    public void setSessionFactoryBeanName(String sessionFactoryBeanName) {
        this.sessionFactoryBeanName = sessionFactoryBeanName;
    }

    protected String getSessionFactoryBeanName() {
        return this.sessionFactoryBeanName;
    }

    public void setSingleSession(boolean singleSession) {
        this.singleSession = singleSession;
    }

    protected boolean isSingleSession() {
        return this.singleSession;
    }

    protected String getAlreadyFilteredAttributeName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.sessionFactoryBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SessionFactory sessionFactory;
        block5: {
            sessionFactory = this.lookupSessionFactory();
            Session session = null;
            if (this.isSingleSession()) {
                this.logger.debug((Object)"Opening single Hibernate session in OpenSessionInViewFilter");
                session = this.getSession(sessionFactory);
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)new SessionHolder(session)));
            } else {
                SessionFactoryUtils.initDeferredClose(sessionFactory);
            }
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                Object var7_6 = null;
                if (!this.isSingleSession()) break block5;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (this.isSingleSession()) {
                    TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
                    this.logger.debug((Object)"Closing single Hibernate session in OpenSessionInViewFilter");
                    this.closeSession(session, sessionFactory);
                    throw throwable;
                }
                SessionFactoryUtils.processDeferredClose(sessionFactory);
                throw throwable;
            }
            TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            this.logger.debug((Object)"Closing single Hibernate session in OpenSessionInViewFilter");
            this.closeSession(session, sessionFactory);
            return;
        }
        SessionFactoryUtils.processDeferredClose(sessionFactory);
    }

    protected SessionFactory lookupSessionFactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using session factory '" + this.getSessionFactoryBeanName() + "' for OpenSessionInViewFilter"));
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (SessionFactory)wac.getBean(this.getSessionFactoryBeanName());
    }

    protected Session getSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        Session session = SessionFactoryUtils.getSession(sessionFactory, true);
        session.setFlushMode(FlushMode.NEVER);
        return session;
    }

    protected void closeSession(Session session, SessionFactory sessionFactory) {
        SessionFactoryUtils.closeSessionIfNecessary(session, sessionFactory);
    }
}

