/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.jaxb;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.JdkVersion;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.oxm.GenericMarshaller;
import org.springframework.oxm.GenericUnmarshaller;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.UncategorizedMappingException;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.ValidationFailureException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.jaxb.ClassPathJaxb2TypeScanner;
import org.springframework.oxm.mime.MimeContainer;
import org.springframework.oxm.mime.MimeMarshaller;
import org.springframework.oxm.mime.MimeUnmarshaller;
import org.springframework.oxm.support.SaxResourceUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jaxb2Marshaller
implements MimeMarshaller,
MimeUnmarshaller,
GenericMarshaller,
GenericUnmarshaller,
BeanClassLoaderAware,
InitializingBean {
    private static final String CID = "cid:";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String contextPath;
    private Class<?>[] classesToBeBound;
    private String[] packagesToScan;
    private Map<String, ?> jaxbContextProperties;
    private Map<String, ?> marshallerProperties;
    private Map<String, ?> unmarshallerProperties;
    private Marshaller.Listener marshallerListener;
    private Unmarshaller.Listener unmarshallerListener;
    private ValidationEventHandler validationEventHandler;
    private XmlAdapter<?, ?>[] adapters;
    private Resource[] schemaResources;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private LSResourceResolver schemaResourceResolver;
    private boolean lazyInit = false;
    private boolean mtomEnabled = false;
    private boolean supportJaxbElementClass = false;
    private boolean checkForXmlRootElement = true;
    private Class<?> mappedClass;
    private ClassLoader beanClassLoader;
    private final Object jaxbContextMonitor = new Object();
    private volatile JAXBContext jaxbContext;
    private Schema schema;
    private boolean processExternalEntities = false;
    private static final EntityResolver NO_OP_ENTITY_RESOLVER = new EntityResolver(){

        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    };

    public void setContextPaths(String ... contextPaths) {
        Assert.notEmpty((Object[])contextPaths, (String)"'contextPaths' must not be empty");
        this.contextPath = StringUtils.arrayToDelimitedString((Object[])contextPaths, (String)":");
    }

    public void setContextPath(String contextPath) {
        Assert.hasText((String)contextPath, (String)"'contextPath' must not be null");
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setClassesToBeBound(Class<?> ... classesToBeBound) {
        Assert.notEmpty((Object[])classesToBeBound, (String)"'classesToBeBound' must not be empty");
        this.classesToBeBound = classesToBeBound;
    }

    public Class<?>[] getClassesToBeBound() {
        return this.classesToBeBound;
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setJaxbContextProperties(Map<String, ?> jaxbContextProperties) {
        this.jaxbContextProperties = jaxbContextProperties;
    }

    public void setMarshallerProperties(Map<String, ?> properties) {
        this.marshallerProperties = properties;
    }

    public void setUnmarshallerProperties(Map<String, ?> properties) {
        this.unmarshallerProperties = properties;
    }

    public void setMarshallerListener(Marshaller.Listener marshallerListener) {
        this.marshallerListener = marshallerListener;
    }

    public void setUnmarshallerListener(Unmarshaller.Listener unmarshallerListener) {
        this.unmarshallerListener = unmarshallerListener;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    public void setAdapters(XmlAdapter<?, ?> ... adapters) {
        this.adapters = adapters;
    }

    public void setSchema(Resource schemaResource) {
        this.schemaResources = new Resource[]{schemaResource};
    }

    public void setSchemas(Resource ... schemaResources) {
        this.schemaResources = schemaResources;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public void setSchemaResourceResolver(LSResourceResolver schemaResourceResolver) {
        this.schemaResourceResolver = schemaResourceResolver;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public void setSupportJaxbElementClass(boolean supportJaxbElementClass) {
        this.supportJaxbElementClass = supportJaxbElementClass;
    }

    public void setCheckForXmlRootElement(boolean checkForXmlRootElement) {
        this.checkForXmlRootElement = checkForXmlRootElement;
    }

    public void setMappedClass(Class<?> mappedClass) {
        this.mappedClass = mappedClass;
    }

    public void setProcessExternalEntities(boolean processExternalEntities) {
        this.processExternalEntities = processExternalEntities;
    }

    public boolean isProcessExternalEntities() {
        return this.processExternalEntities;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() throws Exception {
        boolean hasPackagesToScan;
        boolean hasContextPath = StringUtils.hasLength((String)this.contextPath);
        boolean hasClassesToBeBound = !ObjectUtils.isEmpty((Object[])this.classesToBeBound);
        boolean bl = hasPackagesToScan = !ObjectUtils.isEmpty((Object[])this.packagesToScan);
        if (hasContextPath && (hasClassesToBeBound || hasPackagesToScan) || hasClassesToBeBound && hasPackagesToScan) {
            throw new IllegalArgumentException("Specify either 'contextPath', 'classesToBeBound', or 'packagesToScan'");
        }
        if (!(hasContextPath || hasClassesToBeBound || hasPackagesToScan)) {
            throw new IllegalArgumentException("Setting either 'contextPath', 'classesToBeBound', or 'packagesToScan' is required");
        }
        if (!this.lazyInit) {
            this.getJaxbContext();
        }
        if (!ObjectUtils.isEmpty((Object[])this.schemaResources)) {
            this.schema = this.loadSchema(this.schemaResources, this.schemaLanguage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getJaxbContext() {
        if (this.jaxbContext != null) {
            return this.jaxbContext;
        }
        Object object = this.jaxbContextMonitor;
        synchronized (object) {
            if (this.jaxbContext == null) {
                try {
                    if (StringUtils.hasLength((String)this.contextPath)) {
                        this.jaxbContext = this.createJaxbContextFromContextPath();
                    } else if (!ObjectUtils.isEmpty((Object[])this.classesToBeBound)) {
                        this.jaxbContext = this.createJaxbContextFromClasses();
                    } else if (!ObjectUtils.isEmpty((Object[])this.packagesToScan)) {
                        this.jaxbContext = this.createJaxbContextFromPackages();
                    }
                }
                catch (JAXBException ex) {
                    throw this.convertJaxbException(ex);
                }
            }
            return this.jaxbContext;
        }
    }

    private JAXBContext createJaxbContextFromContextPath() throws JAXBException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Creating JAXBContext with context path [" + this.contextPath + "]"));
        }
        if (this.jaxbContextProperties != null) {
            if (this.beanClassLoader != null) {
                return JAXBContext.newInstance((String)this.contextPath, (ClassLoader)this.beanClassLoader, this.jaxbContextProperties);
            }
            return JAXBContext.newInstance((String)this.contextPath, (ClassLoader)Thread.currentThread().getContextClassLoader(), this.jaxbContextProperties);
        }
        if (this.beanClassLoader != null) {
            return JAXBContext.newInstance((String)this.contextPath, (ClassLoader)this.beanClassLoader);
        }
        return JAXBContext.newInstance((String)this.contextPath);
    }

    private JAXBContext createJaxbContextFromClasses() throws JAXBException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Creating JAXBContext with classes to be bound [" + StringUtils.arrayToCommaDelimitedString((Object[])this.classesToBeBound) + "]"));
        }
        if (this.jaxbContextProperties != null) {
            return JAXBContext.newInstance((Class[])this.classesToBeBound, this.jaxbContextProperties);
        }
        return JAXBContext.newInstance((Class[])this.classesToBeBound);
    }

    private JAXBContext createJaxbContextFromPackages() throws JAXBException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Creating JAXBContext by scanning packages [" + StringUtils.arrayToCommaDelimitedString((Object[])this.packagesToScan) + "]"));
        }
        ClassPathJaxb2TypeScanner scanner = new ClassPathJaxb2TypeScanner(this.beanClassLoader, this.packagesToScan);
        Object[] jaxb2Classes = scanner.scanPackages();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found JAXB2 classes: [" + StringUtils.arrayToCommaDelimitedString((Object[])jaxb2Classes) + "]"));
        }
        this.classesToBeBound = jaxb2Classes;
        if (this.jaxbContextProperties != null) {
            return JAXBContext.newInstance((Class[])jaxb2Classes, this.jaxbContextProperties);
        }
        return JAXBContext.newInstance((Class[])jaxb2Classes);
    }

    private Schema loadSchema(Resource[] resources, String schemaLanguage) throws IOException, SAXException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting validation schema to " + StringUtils.arrayToCommaDelimitedString((Object[])this.schemaResources)));
        }
        Assert.notEmpty((Object[])resources, (String)"No resources given");
        Assert.hasLength((String)schemaLanguage, (String)"No schema language provided");
        Source[] schemaSources = new Source[resources.length];
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        for (int i = 0; i < resources.length; ++i) {
            Assert.notNull((Object)resources[i], (String)"Resource is null");
            Assert.isTrue((boolean)resources[i].exists(), (String)("Resource " + resources[i] + " does not exist"));
            InputSource inputSource = SaxResourceUtils.createInputSource(resources[i]);
            schemaSources[i] = new SAXSource(xmlReader, inputSource);
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance(schemaLanguage);
        if (this.schemaResourceResolver != null) {
            schemaFactory.setResourceResolver(this.schemaResourceResolver);
        }
        return schemaFactory.newSchema(schemaSources);
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return this.supportJaxbElementClass && JAXBElement.class.isAssignableFrom(clazz) || this.supportsInternal(clazz, this.checkForXmlRootElement);
    }

    @Override
    public boolean supports(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            if (JAXBElement.class.equals((Object)parameterizedType.getRawType()) && parameterizedType.getActualTypeArguments().length == 1) {
                Type typeArgument = parameterizedType.getActualTypeArguments()[0];
                if (typeArgument instanceof Class) {
                    Class classArgument = (Class)typeArgument;
                    if (JdkVersion.getMajorJavaVersion() >= 4 && classArgument.isArray()) {
                        return classArgument.getComponentType().equals(Byte.TYPE);
                    }
                    return this.isPrimitiveWrapper(classArgument) || this.isStandardClass(classArgument) || this.supportsInternal(classArgument, false);
                }
                if (JdkVersion.getMajorJavaVersion() <= 3 && typeArgument instanceof GenericArrayType) {
                    GenericArrayType arrayType = (GenericArrayType)typeArgument;
                    return arrayType.getGenericComponentType().equals(Byte.TYPE);
                }
            }
        } else if (genericType instanceof Class) {
            Class clazz = (Class)genericType;
            return this.supportsInternal(clazz, this.checkForXmlRootElement);
        }
        return false;
    }

    private boolean supportsInternal(Class<?> clazz, boolean checkForXmlRootElement) {
        if (checkForXmlRootElement && AnnotationUtils.findAnnotation(clazz, XmlRootElement.class) == null) {
            return false;
        }
        if (StringUtils.hasLength((String)this.contextPath)) {
            String[] contextPaths;
            String packageName = ClassUtils.getPackageName(clazz);
            for (String contextPath : contextPaths = StringUtils.tokenizeToStringArray((String)this.contextPath, (String)":")) {
                if (!contextPath.equals(packageName)) continue;
                return true;
            }
            return false;
        }
        if (!ObjectUtils.isEmpty((Object[])this.classesToBeBound)) {
            return Arrays.asList(this.classesToBeBound).contains(clazz);
        }
        return false;
    }

    private boolean isPrimitiveWrapper(Class<?> clazz) {
        return Boolean.class.equals(clazz) || Byte.class.equals(clazz) || Short.class.equals(clazz) || Integer.class.equals(clazz) || Long.class.equals(clazz) || Float.class.equals(clazz) || Double.class.equals(clazz);
    }

    private boolean isStandardClass(Class<?> clazz) {
        return String.class.equals(clazz) || BigInteger.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || QName.class.isAssignableFrom(clazz) || URI.class.equals(clazz) || XMLGregorianCalendar.class.isAssignableFrom(clazz) || Duration.class.isAssignableFrom(clazz) || Image.class.equals(clazz) || DataHandler.class.equals(clazz) || UUID.class.equals(clazz);
    }

    @Override
    public void marshal(Object graph, Result result) throws XmlMappingException {
        this.marshal(graph, result, null);
    }

    @Override
    public void marshal(Object graph, Result result, MimeContainer mimeContainer) throws XmlMappingException {
        try {
            Marshaller marshaller = this.createMarshaller();
            if (this.mtomEnabled && mimeContainer != null) {
                marshaller.setAttachmentMarshaller((AttachmentMarshaller)new Jaxb2AttachmentMarshaller(mimeContainer));
            }
            if (StaxUtils.isStaxResult((Result)result)) {
                this.marshalStaxResult(marshaller, graph, result);
            } else {
                marshaller.marshal(graph, result);
            }
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    private void marshalStaxResult(Marshaller jaxbMarshaller, Object graph, Result staxResult) throws JAXBException {
        XMLStreamWriter streamWriter = StaxUtils.getXMLStreamWriter((Result)staxResult);
        if (streamWriter != null) {
            jaxbMarshaller.marshal(graph, streamWriter);
        } else {
            XMLEventWriter eventWriter = StaxUtils.getXMLEventWriter((Result)staxResult);
            if (eventWriter != null) {
                jaxbMarshaller.marshal(graph, eventWriter);
            } else {
                throw new IllegalArgumentException("StAX Result contains neither XMLStreamWriter nor XMLEventConsumer");
            }
        }
    }

    protected Marshaller createMarshaller() {
        try {
            Marshaller marshaller = this.getJaxbContext().createMarshaller();
            this.initJaxbMarshaller(marshaller);
            return marshaller;
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    protected void initJaxbMarshaller(Marshaller marshaller) throws JAXBException {
        if (this.marshallerProperties != null) {
            for (String name : this.marshallerProperties.keySet()) {
                marshaller.setProperty(name, this.marshallerProperties.get(name));
            }
        }
        if (this.marshallerListener != null) {
            marshaller.setListener(this.marshallerListener);
        }
        if (this.validationEventHandler != null) {
            marshaller.setEventHandler(this.validationEventHandler);
        }
        if (this.adapters != null) {
            for (XmlAdapter<?, ?> adapter : this.adapters) {
                marshaller.setAdapter(adapter);
            }
        }
        if (this.schema != null) {
            marshaller.setSchema(this.schema);
        }
    }

    @Override
    public Object unmarshal(Source source) throws XmlMappingException {
        return this.unmarshal(source, null);
    }

    @Override
    public Object unmarshal(Source source, MimeContainer mimeContainer) throws XmlMappingException {
        source = this.processSource(source);
        try {
            Unmarshaller unmarshaller = this.createUnmarshaller();
            if (this.mtomEnabled && mimeContainer != null) {
                unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new Jaxb2AttachmentUnmarshaller(mimeContainer));
            }
            if (StaxUtils.isStaxSource((Source)source)) {
                return this.unmarshalStaxSource(unmarshaller, source);
            }
            if (this.mappedClass != null) {
                return unmarshaller.unmarshal(source, this.mappedClass).getValue();
            }
            return unmarshaller.unmarshal(source);
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    protected Object unmarshalStaxSource(Unmarshaller jaxbUnmarshaller, Source staxSource) throws JAXBException {
        XMLStreamReader streamReader = StaxUtils.getXMLStreamReader((Source)staxSource);
        if (streamReader != null) {
            return this.mappedClass != null ? jaxbUnmarshaller.unmarshal(streamReader, this.mappedClass).getValue() : jaxbUnmarshaller.unmarshal(streamReader);
        }
        XMLEventReader eventReader = StaxUtils.getXMLEventReader((Source)staxSource);
        if (eventReader != null) {
            return this.mappedClass != null ? jaxbUnmarshaller.unmarshal(eventReader, this.mappedClass).getValue() : jaxbUnmarshaller.unmarshal(eventReader);
        }
        throw new IllegalArgumentException("StaxSource contains neither XMLStreamReader nor XMLEventReader");
    }

    private Source processSource(Source source) {
        if (StaxUtils.isStaxSource((Source)source) || source instanceof DOMSource) {
            return source;
        }
        XMLReader xmlReader = null;
        InputSource inputSource = null;
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            xmlReader = saxSource.getXMLReader();
            inputSource = saxSource.getInputSource();
        } else if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            inputSource = streamSource.getInputStream() != null ? new InputSource(streamSource.getInputStream()) : (streamSource.getReader() != null ? new InputSource(streamSource.getReader()) : new InputSource(streamSource.getSystemId()));
        }
        try {
            if (xmlReader == null) {
                xmlReader = XMLReaderFactory.createXMLReader();
            }
            String name = "http://xml.org/sax/features/external-general-entities";
            xmlReader.setFeature(name, this.isProcessExternalEntities());
            if (!this.isProcessExternalEntities()) {
                xmlReader.setEntityResolver(NO_OP_ENTITY_RESOLVER);
            }
            return new SAXSource(xmlReader, inputSource);
        }
        catch (SAXException ex) {
            this.logger.warn((Object)"Processing of external entities could not be disabled", (Throwable)ex);
            return source;
        }
    }

    protected Unmarshaller createUnmarshaller() {
        try {
            Unmarshaller unmarshaller = this.getJaxbContext().createUnmarshaller();
            this.initJaxbUnmarshaller(unmarshaller);
            return unmarshaller;
        }
        catch (JAXBException ex) {
            throw this.convertJaxbException(ex);
        }
    }

    protected void initJaxbUnmarshaller(Unmarshaller unmarshaller) throws JAXBException {
        if (this.unmarshallerProperties != null) {
            for (String name : this.unmarshallerProperties.keySet()) {
                unmarshaller.setProperty(name, this.unmarshallerProperties.get(name));
            }
        }
        if (this.unmarshallerListener != null) {
            unmarshaller.setListener(this.unmarshallerListener);
        }
        if (this.validationEventHandler != null) {
            unmarshaller.setEventHandler(this.validationEventHandler);
        }
        if (this.adapters != null) {
            for (XmlAdapter<?, ?> adapter : this.adapters) {
                unmarshaller.setAdapter(adapter);
            }
        }
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
    }

    protected XmlMappingException convertJaxbException(JAXBException ex) {
        if (ex instanceof ValidationException) {
            return new ValidationFailureException("JAXB validation exception", ex);
        }
        if (ex instanceof MarshalException) {
            return new MarshallingFailureException("JAXB marshalling exception", ex);
        }
        if (ex instanceof UnmarshalException) {
            return new UnmarshallingFailureException("JAXB unmarshalling exception", ex);
        }
        return new UncategorizedMappingException("Unknown JAXB exception", ex);
    }

    private static class ByteArrayDataSource
    implements DataSource {
        private final byte[] data;
        private final String contentType;
        private final int offset;
        private final int length;

        public ByteArrayDataSource(String contentType, byte[] data, int offset, int length) {
            this.contentType = contentType;
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data, this.offset, this.length);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return "ByteArrayDataSource";
        }
    }

    private static class Jaxb2AttachmentUnmarshaller
    extends AttachmentUnmarshaller {
        private final MimeContainer mimeContainer;

        public Jaxb2AttachmentUnmarshaller(MimeContainer mimeContainer) {
            this.mimeContainer = mimeContainer;
        }

        public byte[] getAttachmentAsByteArray(String cid) {
            try {
                DataHandler dataHandler = this.getAttachmentAsDataHandler(cid);
                return FileCopyUtils.copyToByteArray((InputStream)dataHandler.getInputStream());
            }
            catch (IOException ex) {
                throw new UnmarshallingFailureException("Couldn't read attachment", ex);
            }
        }

        public DataHandler getAttachmentAsDataHandler(String contentId) {
            if (contentId.startsWith(Jaxb2Marshaller.CID)) {
                contentId = contentId.substring(Jaxb2Marshaller.CID.length());
                try {
                    contentId = URLDecoder.decode(contentId, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                contentId = '<' + contentId + '>';
            }
            return this.mimeContainer.getAttachment(contentId);
        }

        public boolean isXOPPackage() {
            return this.mimeContainer.isXopPackage();
        }
    }

    private static class Jaxb2AttachmentMarshaller
    extends AttachmentMarshaller {
        private final MimeContainer mimeContainer;

        public Jaxb2AttachmentMarshaller(MimeContainer mimeContainer) {
            this.mimeContainer = mimeContainer;
        }

        public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNamespace, String elementLocalName) {
            ByteArrayDataSource dataSource = new ByteArrayDataSource(mimeType, data, offset, length);
            return this.addMtomAttachment(new DataHandler((DataSource)dataSource), elementNamespace, elementLocalName);
        }

        public String addMtomAttachment(DataHandler dataHandler, String elementNamespace, String elementLocalName) {
            String host = this.getHost(elementNamespace, dataHandler);
            String contentId = UUID.randomUUID() + "@" + host;
            this.mimeContainer.addAttachment("<" + contentId + ">", dataHandler);
            try {
                contentId = URLEncoder.encode(contentId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            return Jaxb2Marshaller.CID + contentId;
        }

        private String getHost(String elementNamespace, DataHandler dataHandler) {
            try {
                URI uri = new URI(elementNamespace);
                return uri.getHost();
            }
            catch (URISyntaxException uRISyntaxException) {
                return dataHandler.getName();
            }
        }

        public String addSwaRefAttachment(DataHandler dataHandler) {
            String contentId = UUID.randomUUID() + "@" + dataHandler.getName();
            this.mimeContainer.addAttachment(contentId, dataHandler);
            return contentId;
        }

        public boolean isXOPPackage() {
            return this.mimeContainer.convertToXopPackage();
        }
    }
}

