/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.jmx.MBeanServerNotFoundException;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JmxUtils {
    private static final String MBEAN_SUFFIX = "MBean";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jmx$support$JmxUtils == null ? (class$org$springframework$jmx$support$JmxUtils = JmxUtils.class$("org.springframework.jmx.support.JmxUtils")) : class$org$springframework$jmx$support$JmxUtils));
    static /* synthetic */ Class class$org$springframework$jmx$support$JmxUtils;
    static /* synthetic */ Class class$javax$management$DynamicMBean;
    static /* synthetic */ Class class$java$lang$Object;

    public static MBeanServer locateMBeanServer() throws MBeanServerNotFoundException {
        return JmxUtils.locateMBeanServer(null);
    }

    public static MBeanServer locateMBeanServer(String agentId) throws MBeanServerNotFoundException {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(agentId);
        if (servers == null || servers.size() == 0) {
            throw new MBeanServerNotFoundException("Unable to locate an MBeanServer instance" + (agentId != null ? " with agent id [" + agentId + "]" : ""));
        }
        if (servers.size() > 1) {
            logger.warn((Object)("Found more than one MBeanServer instance" + (agentId != null ? " with agent id [" + agentId + "]" : "") + ". Returning first from list."));
        }
        MBeanServer server = (MBeanServer)servers.get(0);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found MBeanServer: " + server));
        }
        return server;
    }

    public static Class[] parameterInfoToTypes(MBeanParameterInfo[] paramInfo) throws ClassNotFoundException {
        Class[] types = null;
        if (paramInfo != null && paramInfo.length > 0) {
            types = new Class[paramInfo.length];
            for (int x = 0; x < paramInfo.length; ++x) {
                types[x] = ClassUtils.forName((String)paramInfo[x].getType());
            }
        }
        return types;
    }

    public static String[] getMethodSignature(Method method) {
        Class<?>[] types = method.getParameterTypes();
        String[] signature = new String[types.length];
        for (int x = 0; x < types.length; ++x) {
            signature[x] = types[x].getName();
        }
        return signature;
    }

    public static String getAttributeName(PropertyDescriptor property, boolean useStrictCasing) {
        if (useStrictCasing) {
            return StringUtils.capitalize((String)property.getName());
        }
        return property.getName();
    }

    public static boolean isMBean(Class beanClass) {
        if (beanClass == null) {
            return false;
        }
        if ((class$javax$management$DynamicMBean == null ? (class$javax$management$DynamicMBean = JmxUtils.class$("javax.management.DynamicMBean")) : class$javax$management$DynamicMBean).isAssignableFrom(beanClass)) {
            return true;
        }
        for (Class cls = beanClass; cls != null && cls != (class$java$lang$Object == null ? JmxUtils.class$("java.lang.Object") : class$java$lang$Object); cls = cls.getSuperclass()) {
            if (!JmxUtils.hasMBeanInterface(cls)) continue;
            return true;
        }
        return false;
    }

    public static Class getClassToExpose(Object managedBean) {
        if (AopUtils.isCglibProxy((Object)managedBean)) {
            return managedBean.getClass().getSuperclass();
        }
        return managedBean.getClass();
    }

    public static Class getClassToExpose(Class beanClass) {
        if (AopUtils.isCglibProxyClass((Class)beanClass)) {
            return beanClass.getSuperclass();
        }
        return beanClass;
    }

    private static boolean hasMBeanInterface(Class clazz) {
        Class<?>[] implementedInterfaces = clazz.getInterfaces();
        String mbeanInterfaceName = clazz.getName() + MBEAN_SUFFIX;
        for (int x = 0; x < implementedInterfaces.length; ++x) {
            if (!implementedInterfaces[x].getName().equals(mbeanInterfaceName)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

