/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.commonj;

import commonj.work.Work;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.util.Assert;

public class DelegatingWork
implements Work {
    private final Runnable delegate;

    public DelegatingWork(Runnable delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
    }

    public final Runnable getDelegate() {
        return this.delegate;
    }

    public void run() {
        this.delegate.run();
    }

    public boolean isDaemon() {
        if (this.delegate instanceof SchedulingAwareRunnable) {
            return ((SchedulingAwareRunnable)this.delegate).isLongLived();
        }
        return false;
    }

    public void release() {
    }
}

