/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.scripting.support.ScriptFactoryPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class ScriptBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String SCRIPT_FACTORY_POST_PROCESSOR_BEAN_NAME = ".scriptFactoryPostProcessor";
    private static final String SCRIPT_SOURCE_ATTRIBUTE = "script-source";
    private static final String INLINE_SCRIPT_ELEMENT = "inline-script";
    private static final String SCRIPT_INTERFACES_ATTRIBUTE = "script-interfaces";
    private static final String REFRESH_CHECK_DELAY_ATTRIBUTE = "refresh-check-delay";
    private static final String CUSTOMIZER_REF_ATTRIBUTE = "customizer-ref";
    private final Class scriptFactoryClass;
    static /* synthetic */ Class class$org$springframework$scripting$ScriptFactory;
    static /* synthetic */ Class class$org$springframework$scripting$support$ScriptFactoryPostProcessor;

    public ScriptBeanDefinitionParser(Class scriptFactoryClass) {
        Assert.isAssignable((Class)(class$org$springframework$scripting$ScriptFactory == null ? (class$org$springframework$scripting$ScriptFactory = ScriptBeanDefinitionParser.class$("org.springframework.scripting.ScriptFactory")) : class$org$springframework$scripting$ScriptFactory), (Class)scriptFactoryClass);
        this.scriptFactoryClass = scriptFactoryClass;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String value = this.resolveScriptSource(element, parserContext.getReaderContext());
        if (value == null) {
            return null;
        }
        ScriptBeanDefinitionParser.registerScriptFactoryPostProcessorIfNecessary(parserContext.getRegistry());
        RootBeanDefinition beanDefinition = new RootBeanDefinition(this.scriptFactoryClass);
        beanDefinition.setSource(parserContext.extractSource((Object)element));
        this.parseRefreshMetadata(element, beanDefinition);
        ConstructorArgumentValues cav = beanDefinition.getConstructorArgumentValues();
        int constructorArgNum = 0;
        cav.addIndexedArgumentValue(constructorArgNum++, (Object)value);
        if (element.hasAttribute(SCRIPT_INTERFACES_ATTRIBUTE)) {
            cav.addIndexedArgumentValue(constructorArgNum++, (Object)element.getAttribute(SCRIPT_INTERFACES_ATTRIBUTE));
        }
        if (element.hasAttribute(CUSTOMIZER_REF_ATTRIBUTE)) {
            String customizerBeanName = element.getAttribute(CUSTOMIZER_REF_ATTRIBUTE);
            cav.addIndexedArgumentValue(constructorArgNum++, (Object)new RuntimeBeanReference(customizerBeanName));
        }
        parserContext.getDelegate().parsePropertyElements(element, (BeanDefinition)beanDefinition);
        return beanDefinition;
    }

    private void parseRefreshMetadata(Element element, RootBeanDefinition beanDefinition) {
        String refreshCheckDelay = element.getAttribute(REFRESH_CHECK_DELAY_ATTRIBUTE);
        if (StringUtils.hasText((String)refreshCheckDelay)) {
            beanDefinition.setAttribute(ScriptFactoryPostProcessor.REFRESH_CHECK_DELAY_ATTRIBUTE, (Object)new Long(refreshCheckDelay));
        }
    }

    private String resolveScriptSource(Element element, XmlReaderContext readerContext) {
        boolean hasScriptSource = element.hasAttribute(SCRIPT_SOURCE_ATTRIBUTE);
        List elements = DomUtils.getChildElementsByTagName((Element)element, (String)INLINE_SCRIPT_ELEMENT);
        if (hasScriptSource && !elements.isEmpty()) {
            readerContext.error("Only one of 'script-source' and 'inline-script' should be specified.", (Object)element);
            return null;
        }
        if (hasScriptSource) {
            return element.getAttribute(SCRIPT_SOURCE_ATTRIBUTE);
        }
        if (!elements.isEmpty()) {
            Element inlineElement = (Element)elements.get(0);
            return "inline:" + DomUtils.getTextValue((Element)inlineElement);
        }
        readerContext.error("Must specify either 'script-source' or 'inline-script'.", (Object)element);
        return null;
    }

    private static void registerScriptFactoryPostProcessorIfNecessary(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(SCRIPT_FACTORY_POST_PROCESSOR_BEAN_NAME)) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(class$org$springframework$scripting$support$ScriptFactoryPostProcessor == null ? (class$org$springframework$scripting$support$ScriptFactoryPostProcessor = ScriptBeanDefinitionParser.class$("org.springframework.scripting.support.ScriptFactoryPostProcessor")) : class$org$springframework$scripting$support$ScriptFactoryPostProcessor);
            registry.registerBeanDefinition(SCRIPT_FACTORY_POST_PROCESSOR_BEAN_NAME, (BeanDefinition)beanDefinition);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

