/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.annotation;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.annotation.IfProfileValue;
import org.springframework.test.annotation.ProfileValueSource;
import org.springframework.test.annotation.ProfileValueSourceConfiguration;
import org.springframework.test.annotation.SystemProfileValueSource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProfileValueUtils {
    private static final Log logger = LogFactory.getLog(ProfileValueUtils.class);

    public static final ProfileValueSource retrieveProfileValueSource(Class<?> testClass) {
        ProfileValueSource profileValueSource;
        Assert.notNull(testClass, (String)"Can not retrieve a ProfileValueSource for a NULL class.");
        Class<ProfileValueSourceConfiguration> annotationType = ProfileValueSourceConfiguration.class;
        ProfileValueSourceConfiguration config = testClass.getAnnotation(annotationType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved @ProfileValueSourceConfiguration [" + config + "] for test class [" + testClass + "]."));
        }
        Class profileValueSourceType = config != null ? config.value() : (Class)AnnotationUtils.getDefaultValue(annotationType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved ProfileValueSource type [" + profileValueSourceType + "] for class [" + testClass + "]."));
        }
        if (SystemProfileValueSource.class.equals((Object)profileValueSourceType)) {
            profileValueSource = SystemProfileValueSource.getInstance();
        } else {
            try {
                profileValueSource = (ProfileValueSource)profileValueSourceType.newInstance();
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Could not instantiate a ProfileValueSource of type [" + profileValueSourceType + "] for class [" + testClass + "]: using default."), (Throwable)e);
                }
                profileValueSource = SystemProfileValueSource.getInstance();
            }
        }
        return profileValueSource;
    }

    public static final boolean isTestEnabledInThisEnvironment(ProfileValueSource profileValueSource, Method testMethod) {
        boolean enabled = true;
        IfProfileValue ifProfileValue = testMethod.getAnnotation(IfProfileValue.class);
        if (ifProfileValue == null) {
            ifProfileValue = testMethod.getDeclaringClass().getAnnotation(IfProfileValue.class);
        }
        if (ifProfileValue != null) {
            Object[] values;
            Object[] objectArray;
            String name = ifProfileValue.name();
            Assert.hasText((String)name, (String)"The name attribute supplied to @IfProfileValue must not be empty.");
            String environmentValue = profileValueSource.get(name);
            String annotatedValue = ifProfileValue.value();
            Object[] annotatedValues = ifProfileValue.values();
            boolean annotatedValueEmpty = !StringUtils.hasText((String)annotatedValue);
            boolean annotatedValuesEmpty = ObjectUtils.isEmpty((Object[])annotatedValues);
            if (annotatedValueEmpty && annotatedValuesEmpty) {
                throw new IllegalArgumentException("Either the 'value' or 'values' attribute of @IfProfileValue must be set.");
            }
            if (!annotatedValueEmpty && !annotatedValuesEmpty) {
                throw new IllegalArgumentException("Setting both the 'value' and 'values' attributes of @IfProfileValue is not allowed: choose one or the other.");
            }
            if (!annotatedValuesEmpty) {
                objectArray = annotatedValues;
            } else {
                String[] stringArray = new String[1];
                objectArray = stringArray;
                stringArray[0] = annotatedValue;
            }
            for (Object value : values = objectArray) {
                boolean bothValuesAreNull = environmentValue == null && value == null;
                boolean bl = enabled = bothValuesAreNull || environmentValue != null && environmentValue.equals(value);
                if (enabled) break;
            }
        }
        return enabled;
    }
}

