/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextConfigurationAttributes {
    private static final Log logger = LogFactory.getLog(ContextConfigurationAttributes.class);
    private final Class<?> declaringClass;
    private String[] locations;
    private Class<?>[] classes;
    private final boolean inheritLocations;
    private final Class<? extends ContextLoader> contextLoaderClass;
    private final Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>[] initializers;
    private final boolean inheritInitializers;

    private static String[] resolveLocations(Class<?> declaringClass, ContextConfiguration contextConfiguration) {
        Assert.notNull(declaringClass, (String)"declaringClass must not be null");
        Object[] locations = contextConfiguration.locations();
        Object[] valueLocations = contextConfiguration.value();
        if (!ObjectUtils.isEmpty((Object[])valueLocations) && !ObjectUtils.isEmpty((Object[])locations)) {
            String msg = String.format("Test class [%s] has been configured with @ContextConfiguration's 'value' %s and 'locations' %s attributes. Only one declaration of resource locations is permitted per @ContextConfiguration annotation.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])valueLocations), ObjectUtils.nullSafeToString((Object[])locations));
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        if (!ObjectUtils.isEmpty((Object[])valueLocations)) {
            locations = valueLocations;
        }
        return locations;
    }

    public ContextConfigurationAttributes(Class<?> declaringClass, ContextConfiguration contextConfiguration) {
        this(declaringClass, ContextConfigurationAttributes.resolveLocations(declaringClass, contextConfiguration), contextConfiguration.classes(), contextConfiguration.inheritLocations(), contextConfiguration.initializers(), contextConfiguration.inheritInitializers(), contextConfiguration.loader());
    }

    @Deprecated
    public ContextConfigurationAttributes(Class<?> declaringClass, String[] locations, Class<?>[] classes, boolean inheritLocations, Class<? extends ContextLoader> contextLoaderClass) {
        this(declaringClass, locations, classes, inheritLocations, null, true, contextLoaderClass);
    }

    public ContextConfigurationAttributes(Class<?> declaringClass, String[] locations, Class<?>[] classes, boolean inheritLocations, Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>[] initializers, boolean inheritInitializers, Class<? extends ContextLoader> contextLoaderClass) {
        Assert.notNull(declaringClass, (String)"declaringClass must not be null");
        Assert.notNull(contextLoaderClass, (String)"contextLoaderClass must not be null");
        if (!ObjectUtils.isEmpty((Object[])locations) && !ObjectUtils.isEmpty((Object[])classes)) {
            String msg = String.format("Test class [%s] has been configured with @ContextConfiguration's 'locations' (or 'value') %s and 'classes' %s attributes. Only one declaration of resources is permitted per @ContextConfiguration annotation.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])locations), ObjectUtils.nullSafeToString((Object[])classes));
            logger.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        this.declaringClass = declaringClass;
        this.locations = locations;
        this.classes = classes;
        this.inheritLocations = inheritLocations;
        this.initializers = initializers;
        this.inheritInitializers = inheritInitializers;
        this.contextLoaderClass = contextLoaderClass;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void setLocations(String[] locations) {
        this.locations = locations;
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }

    public void setClasses(Class<?>[] classes) {
        this.classes = classes;
    }

    public boolean hasLocations() {
        return !ObjectUtils.isEmpty((Object[])this.getLocations());
    }

    public boolean hasClasses() {
        return !ObjectUtils.isEmpty((Object[])this.getClasses());
    }

    public boolean hasResources() {
        return this.hasLocations() || this.hasClasses();
    }

    public boolean isInheritLocations() {
        return this.inheritLocations;
    }

    public Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>[] getInitializers() {
        return this.initializers;
    }

    public boolean isInheritInitializers() {
        return this.inheritInitializers;
    }

    public Class<? extends ContextLoader> getContextLoaderClass() {
        return this.contextLoaderClass;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("declaringClass", (Object)this.declaringClass.getName()).append("locations", (Object)ObjectUtils.nullSafeToString((Object[])this.locations)).append("classes", (Object)ObjectUtils.nullSafeToString((Object[])this.classes)).append("inheritLocations", this.inheritLocations).append("initializers", (Object)ObjectUtils.nullSafeToString((Object[])this.initializers)).append("inheritInitializers", this.inheritInitializers).append("contextLoaderClass", (Object)this.contextLoaderClass.getName()).toString();
    }
}

