/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.scope;

import javax.servlet.http.HttpSession;
import org.springframework.aop.target.scope.ScopeMap;
import org.springframework.web.context.scope.RequestContextHolder;

public class SessionScopeMap
implements ScopeMap {
    private boolean synchronizeOnSession = false;

    public final void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public boolean isPersistent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name) {
        HttpSession session = RequestContextHolder.currentSession();
        if (this.synchronizeOnSession) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                return session.getAttribute(name);
            }
        }
        return session.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String name, Object value) {
        HttpSession session = RequestContextHolder.currentSession();
        if (this.synchronizeOnSession) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                session.setAttribute(name, value);
            }
        } else {
            session.setAttribute(name, value);
        }
    }

    public void remove(String name) {
        HttpSession session = RequestContextHolder.currentSession();
        session.removeAttribute(name);
    }
}

