/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.StringFormat;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractKotlinSerializationHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;

public abstract class KotlinSerializationStringHttpMessageConverter<T extends StringFormat>
extends AbstractKotlinSerializationHttpMessageConverter<T> {
    protected KotlinSerializationStringHttpMessageConverter(T format, MediaType ... supportedMediaTypes) {
        super(format, supportedMediaTypes);
    }

    @Override
    protected Object readInternal(KSerializer<Object> serializer, T format, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Charset charset = KotlinSerializationStringHttpMessageConverter.charset(inputMessage.getHeaders().getContentType());
        String s = StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)charset);
        try {
            return format.decodeFromString(serializer, s);
        }
        catch (SerializationException ex) {
            throw new HttpMessageNotReadableException("Could not read " + String.valueOf(format) + ": " + ex.getMessage(), ex, inputMessage);
        }
    }

    @Override
    protected void writeInternal(Object object, KSerializer<Object> serializer, T format, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try {
            String s = format.encodeToString(serializer, object);
            Charset charset = KotlinSerializationStringHttpMessageConverter.charset(outputMessage.getHeaders().getContentType());
            outputMessage.getBody().write(s.getBytes(charset));
            outputMessage.getBody().flush();
        }
        catch (SerializationException ex) {
            throw new HttpMessageNotWritableException("Could not write " + String.valueOf(format) + ": " + ex.getMessage(), ex);
        }
    }

    private static Charset charset(@Nullable MediaType contentType) {
        if (contentType != null && contentType.getCharset() != null) {
            return contentType.getCharset();
        }
        return StandardCharsets.UTF_8;
    }
}

