/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.Ordered;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.converter.xml.XmlAwareFormHttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.Model;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.validation.support.BindingAwareModelMap;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.annotation.support.HandlerMethodInvoker;
import org.springframework.web.bind.annotation.support.HandlerMethodResolver;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.annotation.DefaultAnnotationHandlerMapping;
import org.springframework.web.servlet.mvc.annotation.ModelAndViewResolver;
import org.springframework.web.servlet.mvc.annotation.ServletAnnotationMappingUtils;
import org.springframework.web.servlet.mvc.multiaction.InternalPathMethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMethodHandlerAdapter
extends WebContentGenerator
implements HandlerAdapter,
Ordered,
BeanFactoryAware {
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private MethodNameResolver methodNameResolver = new InternalPathMethodNameResolver();
    private WebBindingInitializer webBindingInitializer;
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private int cacheSecondsForSessionAttributeHandlers = 0;
    private boolean synchronizeOnSession = false;
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private WebArgumentResolver[] customArgumentResolvers;
    private ModelAndViewResolver[] customModelAndViewResolvers;
    private HttpMessageConverter<?>[] messageConverters;
    private int order = Integer.MAX_VALUE;
    private ConfigurableBeanFactory beanFactory;
    private BeanExpressionContext expressionContext;
    private final Map<Class<?>, ServletHandlerMethodResolver> methodResolverCache = new ConcurrentHashMap(64);
    private final Map<Class<?>, Boolean> sessionAnnotatedClassesCache = new ConcurrentHashMap(64);

    public AnnotationMethodHandlerAdapter() {
        super(false);
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        this.messageConverters = new HttpMessageConverter[]{new ByteArrayHttpMessageConverter(), stringHttpMessageConverter, new SourceHttpMessageConverter(), new XmlAwareFormHttpMessageConverter()};
    }

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper, (String)"UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public void setMethodNameResolver(MethodNameResolver methodNameResolver) {
        this.methodNameResolver = methodNameResolver;
    }

    public void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public void setSessionAttributeStore(SessionAttributeStore sessionAttributeStore) {
        Assert.notNull((Object)sessionAttributeStore, (String)"SessionAttributeStore must not be null");
        this.sessionAttributeStore = sessionAttributeStore;
    }

    public void setCacheSecondsForSessionAttributeHandlers(int cacheSecondsForSessionAttributeHandlers) {
        this.cacheSecondsForSessionAttributeHandlers = cacheSecondsForSessionAttributeHandlers;
    }

    public void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setCustomArgumentResolver(WebArgumentResolver argumentResolver) {
        this.customArgumentResolvers = new WebArgumentResolver[]{argumentResolver};
    }

    public void setCustomArgumentResolvers(WebArgumentResolver[] argumentResolvers) {
        this.customArgumentResolvers = argumentResolvers;
    }

    public void setCustomModelAndViewResolver(ModelAndViewResolver customModelAndViewResolver) {
        this.customModelAndViewResolvers = new ModelAndViewResolver[]{customModelAndViewResolver};
    }

    public void setCustomModelAndViewResolvers(ModelAndViewResolver[] customModelAndViewResolvers) {
        this.customModelAndViewResolvers = customModelAndViewResolvers;
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    public HttpMessageConverter<?>[] getMessageConverters() {
        return this.messageConverters;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
            this.expressionContext = new BeanExpressionContext(this.beanFactory, (Scope)new RequestScope());
        }
    }

    @Override
    public boolean supports(Object handler) {
        return this.getMethodResolver(handler).hasHandlerMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HttpSession session;
        Class clazz = ClassUtils.getUserClass((Object)handler);
        Boolean annotatedWithSessionAttributes = this.sessionAnnotatedClassesCache.get(clazz);
        if (annotatedWithSessionAttributes == null) {
            annotatedWithSessionAttributes = AnnotationUtils.findAnnotation((Class)clazz, SessionAttributes.class) != null;
            this.sessionAnnotatedClassesCache.put(clazz, annotatedWithSessionAttributes);
        }
        if (annotatedWithSessionAttributes.booleanValue()) {
            this.checkAndPrepare(request, response, this.cacheSecondsForSessionAttributeHandlers, true);
        } else {
            this.checkAndPrepare(request, response, true);
        }
        if (this.synchronizeOnSession && (session = request.getSession(false)) != null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
            synchronized (object) {
                return this.invokeHandlerMethod(request, response, handler);
            }
        }
        return this.invokeHandlerMethod(request, response, handler);
    }

    protected ModelAndView invokeHandlerMethod(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ServletHandlerMethodResolver methodResolver = this.getMethodResolver(handler);
        Method handlerMethod = methodResolver.resolveHandlerMethod(request);
        ServletHandlerMethodInvoker methodInvoker = new ServletHandlerMethodInvoker(methodResolver);
        ServletWebRequest webRequest = new ServletWebRequest(request, response);
        BindingAwareModelMap implicitModel = new BindingAwareModelMap();
        Object result = methodInvoker.invokeHandlerMethod(handlerMethod, handler, (NativeWebRequest)webRequest, (ExtendedModelMap)implicitModel);
        ModelAndView mav = methodInvoker.getModelAndView(handlerMethod, handler.getClass(), result, (ExtendedModelMap)implicitModel, webRequest);
        methodInvoker.updateModelAttributes(handler, mav != null ? mav.getModel() : null, (ExtendedModelMap)implicitModel, (NativeWebRequest)webRequest);
        return mav;
    }

    @Override
    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletHandlerMethodResolver getMethodResolver(Object handler) {
        Class handlerClass = ClassUtils.getUserClass((Object)handler);
        ServletHandlerMethodResolver resolver = this.methodResolverCache.get(handlerClass);
        if (resolver == null) {
            Map<Class<?>, ServletHandlerMethodResolver> map = this.methodResolverCache;
            synchronized (map) {
                resolver = this.methodResolverCache.get(handlerClass);
                if (resolver == null) {
                    resolver = new ServletHandlerMethodResolver(handlerClass);
                    this.methodResolverCache.put(handlerClass, resolver);
                }
            }
        }
        return resolver;
    }

    protected ServletRequestDataBinder createBinder(HttpServletRequest request, Object target, String objectName) throws Exception {
        return new ServletRequestDataBinder(target, objectName);
    }

    protected HttpInputMessage createHttpInputMessage(HttpServletRequest servletRequest) throws Exception {
        return new ServletServerHttpRequest(servletRequest);
    }

    protected HttpOutputMessage createHttpOutputMessage(HttpServletResponse servletResponse) throws Exception {
        return new ServletServerHttpResponse(servletResponse);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RequestSpecificMappingInfoComparator
    implements Comparator<RequestSpecificMappingInfo> {
        private final Comparator<String> pathComparator;
        private final ServerHttpRequest request;

        RequestSpecificMappingInfoComparator(Comparator<String> pathComparator, HttpServletRequest request) {
            this.pathComparator = pathComparator;
            this.request = new ServletServerHttpRequest(request);
        }

        @Override
        public int compare(RequestSpecificMappingInfo info1, RequestSpecificMappingInfo info2) {
            int info2HeaderCount;
            int info2ParamCount;
            int pathComparison = this.pathComparator.compare(info1.bestMatchedPattern(), info2.bestMatchedPattern());
            if (pathComparison != 0) {
                return pathComparison;
            }
            int info1ParamCount = info1.getParamCount();
            if (info1ParamCount != (info2ParamCount = info2.getParamCount())) {
                return info2ParamCount - info1ParamCount;
            }
            int info1HeaderCount = info1.getHeaderCount();
            if (info1HeaderCount != (info2HeaderCount = info2.getHeaderCount())) {
                return info2HeaderCount - info1HeaderCount;
            }
            int acceptComparison = this.compareAcceptHeaders(info1, info2);
            if (acceptComparison != 0) {
                return acceptComparison;
            }
            int info1MethodCount = info1.getMethodCount();
            int info2MethodCount = info2.getMethodCount();
            if (info1MethodCount == 0 && info2MethodCount > 0) {
                return 1;
            }
            if (info2MethodCount == 0 && info1MethodCount > 0) {
                return -1;
            }
            if (info1MethodCount == 1 & info2MethodCount > 1) {
                return -1;
            }
            if (info2MethodCount == 1 & info1MethodCount > 1) {
                return 1;
            }
            return 0;
        }

        private int compareAcceptHeaders(RequestMappingInfo info1, RequestMappingInfo info2) {
            List requestAccepts = this.request.getHeaders().getAccept();
            MediaType.sortByQualityValue((List)requestAccepts);
            List<MediaType> info1Accepts = this.getAcceptHeaderValue(info1);
            List<MediaType> info2Accepts = this.getAcceptHeaderValue(info2);
            for (MediaType requestAccept : requestAccepts) {
                int pos2;
                int pos1 = this.indexOfIncluded(info1Accepts, requestAccept);
                if (pos1 == (pos2 = this.indexOfIncluded(info2Accepts, requestAccept))) continue;
                return pos2 - pos1;
            }
            return 0;
        }

        private int indexOfIncluded(List<MediaType> infoAccepts, MediaType requestAccept) {
            for (int i = 0; i < infoAccepts.size(); ++i) {
                MediaType info1Accept = infoAccepts.get(i);
                if (!requestAccept.includes(info1Accept)) continue;
                return i;
            }
            return -1;
        }

        private List<MediaType> getAcceptHeaderValue(RequestMappingInfo info) {
            for (String header : info.headers) {
                int separator = header.indexOf(61);
                if (separator == -1) continue;
                String key = header.substring(0, separator);
                String value = header.substring(separator + 1);
                if (!"Accept".equalsIgnoreCase(key)) continue;
                return MediaType.parseMediaTypes((String)value);
            }
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RequestSpecificMappingInfo
    extends RequestMappingInfo {
        private final List<String> matchedPatterns = new ArrayList<String>();

        RequestSpecificMappingInfo(String[] patterns, RequestMethod[] methods, String[] params, String[] headers) {
            super(patterns, methods, params, headers);
        }

        RequestSpecificMappingInfo(RequestMappingInfo other) {
            super(other.patterns, other.methods, other.params, other.headers);
        }

        public void addMatchedPattern(String matchedPattern) {
            this.matchedPatterns.add(matchedPattern);
        }

        public void sortMatchedPatterns(Comparator<String> pathComparator) {
            Collections.sort(this.matchedPatterns, pathComparator);
        }

        public String bestMatchedPattern() {
            return !this.matchedPatterns.isEmpty() ? this.matchedPatterns.get(0) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RequestMappingInfo {
        private final String[] patterns;
        private final RequestMethod[] methods;
        private final String[] params;
        private final String[] headers;

        RequestMappingInfo(String[] patterns, RequestMethod[] methods, String[] params, String[] headers) {
            this.patterns = patterns != null ? patterns : new String[]{};
            this.methods = methods != null ? methods : new RequestMethod[]{};
            this.params = params != null ? params : new String[]{};
            this.headers = headers != null ? headers : new String[]{};
        }

        public boolean hasPatterns() {
            return this.patterns.length > 0;
        }

        public String[] getPatterns() {
            return this.patterns;
        }

        public int getMethodCount() {
            return this.methods.length;
        }

        public int getParamCount() {
            return this.params.length;
        }

        public int getHeaderCount() {
            return this.headers.length;
        }

        public boolean matches(HttpServletRequest request) {
            return this.matchesRequestMethod(request) && this.matchesParameters(request) && this.matchesHeaders(request);
        }

        public boolean matchesHeaders(HttpServletRequest request) {
            return ServletAnnotationMappingUtils.checkHeaders(this.headers, request);
        }

        public boolean matchesParameters(HttpServletRequest request) {
            return ServletAnnotationMappingUtils.checkParameters(this.params, request);
        }

        public boolean matchesRequestMethod(HttpServletRequest request) {
            return ServletAnnotationMappingUtils.checkRequestMethod(this.methods, request);
        }

        public Set<String> methodNames() {
            LinkedHashSet<String> methodNames = new LinkedHashSet<String>(this.methods.length);
            for (RequestMethod method : this.methods) {
                methodNames.add(method.name());
            }
            return methodNames;
        }

        public boolean equals(Object obj) {
            RequestMappingInfo other = (RequestMappingInfo)obj;
            return Arrays.equals(this.patterns, other.patterns) && Arrays.equals(this.methods, other.methods) && Arrays.equals(this.params, other.params) && Arrays.equals(this.headers, other.headers);
        }

        public int hashCode() {
            return Arrays.hashCode(this.patterns) * 23 + Arrays.hashCode(this.methods) * 29 + Arrays.hashCode(this.params) * 31 + Arrays.hashCode(this.headers);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(Arrays.asList(this.patterns));
            if (this.methods.length > 0) {
                builder.append(',');
                builder.append(Arrays.asList(this.methods));
            }
            if (this.headers.length > 0) {
                builder.append(',');
                builder.append(Arrays.asList(this.headers));
            }
            if (this.params.length > 0) {
                builder.append(',');
                builder.append(Arrays.asList(this.params));
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServletHandlerMethodInvoker
    extends HandlerMethodInvoker {
        private boolean responseArgumentUsed;

        private ServletHandlerMethodInvoker(HandlerMethodResolver resolver) {
            super(resolver, AnnotationMethodHandlerAdapter.this.webBindingInitializer, AnnotationMethodHandlerAdapter.this.sessionAttributeStore, AnnotationMethodHandlerAdapter.this.parameterNameDiscoverer, AnnotationMethodHandlerAdapter.this.customArgumentResolvers, AnnotationMethodHandlerAdapter.this.messageConverters);
            this.responseArgumentUsed = false;
        }

        protected void raiseMissingParameterException(String paramName, Class paramType) throws Exception {
            throw new MissingServletRequestParameterException(paramName, paramType.getSimpleName());
        }

        protected void raiseSessionRequiredException(String message) throws Exception {
            throw new HttpSessionRequiredException(message);
        }

        protected WebDataBinder createBinder(NativeWebRequest webRequest, Object target, String objectName) throws Exception {
            return AnnotationMethodHandlerAdapter.this.createBinder((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class), target, objectName);
        }

        protected void doBind(WebDataBinder binder, NativeWebRequest webRequest) throws Exception {
            ServletRequestDataBinder servletBinder = (ServletRequestDataBinder)binder;
            servletBinder.bind((ServletRequest)webRequest.getNativeRequest(ServletRequest.class));
        }

        protected HttpInputMessage createHttpInputMessage(NativeWebRequest webRequest) throws Exception {
            HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            return AnnotationMethodHandlerAdapter.this.createHttpInputMessage(servletRequest);
        }

        protected HttpOutputMessage createHttpOutputMessage(NativeWebRequest webRequest) throws Exception {
            HttpServletResponse servletResponse = (HttpServletResponse)webRequest.getNativeResponse();
            return AnnotationMethodHandlerAdapter.this.createHttpOutputMessage(servletResponse);
        }

        protected Object resolveDefaultValue(String value) {
            if (AnnotationMethodHandlerAdapter.this.beanFactory == null) {
                return value;
            }
            String placeholdersResolved = AnnotationMethodHandlerAdapter.this.beanFactory.resolveEmbeddedValue(value);
            BeanExpressionResolver exprResolver = AnnotationMethodHandlerAdapter.this.beanFactory.getBeanExpressionResolver();
            if (exprResolver == null) {
                return value;
            }
            return exprResolver.evaluate(placeholdersResolved, AnnotationMethodHandlerAdapter.this.expressionContext);
        }

        protected Object resolveCookieValue(String cookieName, Class paramType, NativeWebRequest webRequest) throws Exception {
            HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            Cookie cookieValue = WebUtils.getCookie((HttpServletRequest)servletRequest, (String)cookieName);
            if (Cookie.class.isAssignableFrom(paramType)) {
                return cookieValue;
            }
            if (cookieValue != null) {
                return AnnotationMethodHandlerAdapter.this.urlPathHelper.decodeRequestString(servletRequest, cookieValue.getValue());
            }
            return null;
        }

        protected String resolvePathVariable(String pathVarName, Class paramType, NativeWebRequest webRequest) throws Exception {
            HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            Map uriTemplateVariables = (Map)servletRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            if (uriTemplateVariables == null || !uriTemplateVariables.containsKey(pathVarName)) {
                throw new IllegalStateException("Could not find @PathVariable [" + pathVarName + "] in @RequestMapping");
            }
            return (String)uriTemplateVariables.get(pathVarName);
        }

        protected Object resolveStandardArgument(Class<?> parameterType, NativeWebRequest webRequest) throws Exception {
            HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
            if (ServletRequest.class.isAssignableFrom(parameterType) || MultipartRequest.class.isAssignableFrom(parameterType)) {
                Object nativeRequest = webRequest.getNativeRequest(parameterType);
                if (nativeRequest == null) {
                    throw new IllegalStateException("Current request is not of type [" + parameterType.getName() + "]: " + request);
                }
                return nativeRequest;
            }
            if (ServletResponse.class.isAssignableFrom(parameterType)) {
                this.responseArgumentUsed = true;
                Object nativeResponse = webRequest.getNativeResponse(parameterType);
                if (nativeResponse == null) {
                    throw new IllegalStateException("Current response is not of type [" + parameterType.getName() + "]: " + response);
                }
                return nativeResponse;
            }
            if (HttpSession.class.isAssignableFrom(parameterType)) {
                return request.getSession();
            }
            if (Principal.class.isAssignableFrom(parameterType)) {
                return request.getUserPrincipal();
            }
            if (Locale.class.equals(parameterType)) {
                return RequestContextUtils.getLocale(request);
            }
            if (InputStream.class.isAssignableFrom(parameterType)) {
                return request.getInputStream();
            }
            if (Reader.class.isAssignableFrom(parameterType)) {
                return request.getReader();
            }
            if (OutputStream.class.isAssignableFrom(parameterType)) {
                this.responseArgumentUsed = true;
                return response.getOutputStream();
            }
            if (Writer.class.isAssignableFrom(parameterType)) {
                this.responseArgumentUsed = true;
                return response.getWriter();
            }
            return super.resolveStandardArgument(parameterType, webRequest);
        }

        public ModelAndView getModelAndView(Method handlerMethod, Class handlerType, Object returnValue, ExtendedModelMap implicitModel, ServletWebRequest webRequest) throws Exception {
            ResponseStatus responseStatusAnn = (ResponseStatus)AnnotationUtils.findAnnotation((Method)handlerMethod, ResponseStatus.class);
            if (responseStatusAnn != null) {
                HttpStatus responseStatus = responseStatusAnn.value();
                String reason = responseStatusAnn.reason();
                if (!StringUtils.hasText((String)reason)) {
                    webRequest.getResponse().setStatus(responseStatus.value());
                } else {
                    webRequest.getResponse().sendError(responseStatus.value(), reason);
                }
                webRequest.getRequest().setAttribute(View.RESPONSE_STATUS_ATTRIBUTE, (Object)responseStatus);
                this.responseArgumentUsed = true;
            }
            if (AnnotationMethodHandlerAdapter.this.customModelAndViewResolvers != null) {
                for (ModelAndViewResolver mavResolver : AnnotationMethodHandlerAdapter.this.customModelAndViewResolvers) {
                    ModelAndView mav = mavResolver.resolveModelAndView(handlerMethod, handlerType, returnValue, implicitModel, (NativeWebRequest)webRequest);
                    if (mav == ModelAndViewResolver.UNRESOLVED) continue;
                    return mav;
                }
            }
            if (returnValue instanceof HttpEntity) {
                this.handleHttpEntityResponse((HttpEntity)returnValue, webRequest);
                return null;
            }
            if (AnnotationUtils.findAnnotation((Method)handlerMethod, ResponseBody.class) != null) {
                this.handleResponseBody(returnValue, webRequest);
                return null;
            }
            if (returnValue instanceof ModelAndView) {
                ModelAndView mav = (ModelAndView)returnValue;
                mav.getModelMap().mergeAttributes((Map)implicitModel);
                return mav;
            }
            if (returnValue instanceof Model) {
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel).addAllObjects(((Model)returnValue).asMap());
            }
            if (returnValue instanceof View) {
                return new ModelAndView((View)returnValue).addAllObjects((Map<String, ?>)implicitModel);
            }
            if (AnnotationUtils.findAnnotation((Method)handlerMethod, ModelAttribute.class) != null) {
                this.addReturnValueAsModelAttribute(handlerMethod, handlerType, returnValue, implicitModel);
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel);
            }
            if (returnValue instanceof Map) {
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel).addAllObjects((Map)returnValue);
            }
            if (returnValue instanceof String) {
                return new ModelAndView((String)returnValue).addAllObjects((Map<String, ?>)implicitModel);
            }
            if (returnValue == null) {
                if (this.responseArgumentUsed || webRequest.isNotModified()) {
                    return null;
                }
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel);
            }
            if (!BeanUtils.isSimpleProperty(returnValue.getClass())) {
                this.addReturnValueAsModelAttribute(handlerMethod, handlerType, returnValue, implicitModel);
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel);
            }
            throw new IllegalArgumentException("Invalid handler method return value: " + returnValue);
        }

        private void handleResponseBody(Object returnValue, ServletWebRequest webRequest) throws Exception {
            if (returnValue == null) {
                return;
            }
            HttpInputMessage inputMessage = this.createHttpInputMessage((NativeWebRequest)webRequest);
            HttpOutputMessage outputMessage = this.createHttpOutputMessage((NativeWebRequest)webRequest);
            this.writeWithMessageConverters(returnValue, inputMessage, outputMessage);
        }

        private void handleHttpEntityResponse(HttpEntity<?> responseEntity, ServletWebRequest webRequest) throws Exception {
            Object body;
            HttpHeaders entityHeaders;
            if (responseEntity == null) {
                return;
            }
            HttpInputMessage inputMessage = this.createHttpInputMessage((NativeWebRequest)webRequest);
            HttpOutputMessage outputMessage = this.createHttpOutputMessage((NativeWebRequest)webRequest);
            if (responseEntity instanceof ResponseEntity && outputMessage instanceof ServerHttpResponse) {
                ((ServerHttpResponse)outputMessage).setStatusCode(((ResponseEntity)responseEntity).getStatusCode());
            }
            if (!(entityHeaders = responseEntity.getHeaders()).isEmpty()) {
                outputMessage.getHeaders().putAll((Map)entityHeaders);
            }
            if ((body = responseEntity.getBody()) != null) {
                this.writeWithMessageConverters(body, inputMessage, outputMessage);
            } else {
                outputMessage.getBody();
            }
        }

        private void writeWithMessageConverters(Object returnValue, HttpInputMessage inputMessage, HttpOutputMessage outputMessage) throws IOException, HttpMediaTypeNotAcceptableException {
            List<MediaType> acceptedMediaTypes = inputMessage.getHeaders().getAccept();
            if (acceptedMediaTypes.isEmpty()) {
                acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
            }
            MediaType.sortByQualityValue((List)acceptedMediaTypes);
            Class<?> returnValueType = returnValue.getClass();
            ArrayList allSupportedMediaTypes = new ArrayList();
            if (AnnotationMethodHandlerAdapter.this.getMessageConverters() != null) {
                for (MediaType acceptedMediaType : acceptedMediaTypes) {
                    for (HttpMessageConverter<?> messageConverter : AnnotationMethodHandlerAdapter.this.getMessageConverters()) {
                        if (!messageConverter.canWrite(returnValueType, acceptedMediaType)) continue;
                        messageConverter.write(returnValue, acceptedMediaType, outputMessage);
                        if (AnnotationMethodHandlerAdapter.this.logger.isDebugEnabled()) {
                            MediaType contentType = outputMessage.getHeaders().getContentType();
                            if (contentType == null) {
                                contentType = acceptedMediaType;
                            }
                            AnnotationMethodHandlerAdapter.this.logger.debug((Object)("Written [" + returnValue + "] as \"" + contentType + "\" using [" + messageConverter + "]"));
                        }
                        this.responseArgumentUsed = true;
                        return;
                    }
                }
                for (HttpMessageConverter messageConverter : AnnotationMethodHandlerAdapter.this.messageConverters) {
                    allSupportedMediaTypes.addAll(messageConverter.getSupportedMediaTypes());
                }
            }
            throw new HttpMediaTypeNotAcceptableException(allSupportedMediaTypes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServletHandlerMethodResolver
    extends HandlerMethodResolver {
        private final Map<Method, RequestMappingInfo> mappings = new HashMap<Method, RequestMappingInfo>();

        private ServletHandlerMethodResolver(Class<?> handlerType) {
            this.init(handlerType);
        }

        protected boolean isHandlerMethod(Method method) {
            if (this.mappings.containsKey(method)) {
                return true;
            }
            RequestMapping mapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
            if (mapping != null) {
                String[] patterns = mapping.value();
                RequestMethod[] methods = new RequestMethod[]{};
                String[] params = new String[]{};
                String[] headers = new String[]{};
                if (!this.hasTypeLevelMapping() || !Arrays.equals(mapping.method(), this.getTypeLevelMapping().method())) {
                    methods = mapping.method();
                }
                if (!this.hasTypeLevelMapping() || !Arrays.equals(mapping.params(), this.getTypeLevelMapping().params())) {
                    params = mapping.params();
                }
                if (!this.hasTypeLevelMapping() || !Arrays.equals(mapping.headers(), this.getTypeLevelMapping().headers())) {
                    headers = mapping.headers();
                }
                RequestMappingInfo mappingInfo = new RequestMappingInfo(patterns, methods, params, headers);
                this.mappings.put(method, mappingInfo);
                return true;
            }
            return false;
        }

        public Method resolveHandlerMethod(HttpServletRequest request) throws ServletException {
            String lookupPath = AnnotationMethodHandlerAdapter.this.urlPathHelper.getLookupPathForRequest(request);
            Comparator pathComparator = AnnotationMethodHandlerAdapter.this.pathMatcher.getPatternComparator(lookupPath);
            LinkedHashMap<RequestSpecificMappingInfo, Method> targetHandlerMethods = new LinkedHashMap<RequestSpecificMappingInfo, Method>();
            LinkedHashSet<String> allowedMethods = new LinkedHashSet<String>(7);
            String resolvedMethodName = null;
            for (Method handlerMethod : this.getHandlerMethods()) {
                Method oldMappedMethod;
                RequestSpecificMappingInfo mappingInfo = new RequestSpecificMappingInfo(this.mappings.get(handlerMethod));
                boolean match = false;
                if (mappingInfo.hasPatterns()) {
                    for (String pattern : mappingInfo.getPatterns()) {
                        String combinedPattern;
                        if (!this.hasTypeLevelMapping() && !pattern.startsWith("/")) {
                            pattern = "/" + pattern;
                        }
                        if ((combinedPattern = this.getCombinedPattern(pattern, lookupPath, request)) == null) continue;
                        if (mappingInfo.matches(request)) {
                            match = true;
                            mappingInfo.addMatchedPattern(combinedPattern);
                            continue;
                        }
                        if (mappingInfo.matchesRequestMethod(request)) break;
                        allowedMethods.addAll(mappingInfo.methodNames());
                        break;
                    }
                    mappingInfo.sortMatchedPatterns(pathComparator);
                } else if (this.useTypeLevelMapping(request)) {
                    String[] typeLevelPatterns;
                    for (String typeLevelPattern : typeLevelPatterns = this.getTypeLevelMapping().value()) {
                        boolean useSuffixPattern;
                        if (!typeLevelPattern.startsWith("/")) {
                            typeLevelPattern = "/" + typeLevelPattern;
                        }
                        if (this.getMatchingPattern(typeLevelPattern, lookupPath, useSuffixPattern = this.useSuffixPattern(request)) == null) continue;
                        if (mappingInfo.matches(request)) {
                            match = true;
                            mappingInfo.addMatchedPattern(typeLevelPattern);
                            continue;
                        }
                        if (mappingInfo.matchesRequestMethod(request)) break;
                        allowedMethods.addAll(mappingInfo.methodNames());
                        break;
                    }
                    mappingInfo.sortMatchedPatterns(pathComparator);
                } else {
                    match = mappingInfo.matches(request);
                    if (match && mappingInfo.getMethodCount() == 0 && mappingInfo.getParamCount() == 0 && resolvedMethodName != null && !resolvedMethodName.equals(handlerMethod.getName())) {
                        match = false;
                    } else if (!mappingInfo.matchesRequestMethod(request)) {
                        allowedMethods.addAll(mappingInfo.methodNames());
                    }
                }
                if (!match || (oldMappedMethod = targetHandlerMethods.put(mappingInfo, handlerMethod)) == null || oldMappedMethod == handlerMethod) continue;
                if (AnnotationMethodHandlerAdapter.this.methodNameResolver != null && !mappingInfo.hasPatterns() && !oldMappedMethod.getName().equals(handlerMethod.getName())) {
                    if (resolvedMethodName == null) {
                        resolvedMethodName = AnnotationMethodHandlerAdapter.this.methodNameResolver.getHandlerMethodName(request);
                    }
                    if (!resolvedMethodName.equals(oldMappedMethod.getName())) {
                        oldMappedMethod = null;
                    }
                    if (!resolvedMethodName.equals(handlerMethod.getName())) {
                        if (oldMappedMethod != null) {
                            targetHandlerMethods.put(mappingInfo, oldMappedMethod);
                            oldMappedMethod = null;
                        } else {
                            targetHandlerMethods.remove(mappingInfo);
                        }
                    }
                }
                if (oldMappedMethod == null) continue;
                throw new IllegalStateException("Ambiguous handler methods mapped for HTTP path '" + lookupPath + "': {" + oldMappedMethod + ", " + handlerMethod + "}. If you intend to handle the same path in multiple methods, then factor " + "them out into a dedicated handler class with that path mapped at the type level!");
            }
            if (!targetHandlerMethods.isEmpty()) {
                ArrayList matches = new ArrayList(targetHandlerMethods.keySet());
                RequestSpecificMappingInfoComparator requestMappingInfoComparator = new RequestSpecificMappingInfoComparator(pathComparator, request);
                Collections.sort(matches, requestMappingInfoComparator);
                RequestSpecificMappingInfo bestMappingMatch = (RequestSpecificMappingInfo)matches.get(0);
                String bestMatchedPath = bestMappingMatch.bestMatchedPattern();
                if (bestMatchedPath != null) {
                    this.extractHandlerMethodUriTemplates(bestMatchedPath, lookupPath, request);
                }
                return (Method)targetHandlerMethods.get(bestMappingMatch);
            }
            if (!allowedMethods.isEmpty()) {
                throw new HttpRequestMethodNotSupportedException(request.getMethod(), StringUtils.toStringArray(allowedMethods));
            }
            throw new NoSuchRequestHandlingMethodException(lookupPath, request.getMethod(), request.getParameterMap());
        }

        private boolean useTypeLevelMapping(HttpServletRequest request) {
            if (!this.hasTypeLevelMapping() || ObjectUtils.isEmpty((Object[])this.getTypeLevelMapping().value())) {
                return false;
            }
            Object value = request.getAttribute(HandlerMapping.INTROSPECT_TYPE_LEVEL_MAPPING);
            return value != null ? (Boolean)value : Boolean.TRUE;
        }

        private boolean useSuffixPattern(HttpServletRequest request) {
            Object value = request.getAttribute(DefaultAnnotationHandlerMapping.USE_DEFAULT_SUFFIX_PATTERN);
            return value != null ? (Boolean)value : Boolean.TRUE;
        }

        private String getCombinedPattern(String methodLevelPattern, String lookupPath, HttpServletRequest request) {
            String combinedPattern;
            String matchingPattern;
            boolean useSuffixPattern = this.useSuffixPattern(request);
            if (this.useTypeLevelMapping(request)) {
                String[] typeLevelPatterns;
                for (String typeLevelPattern : typeLevelPatterns = this.getTypeLevelMapping().value()) {
                    String combinedPattern2;
                    String matchingPattern2;
                    if (!typeLevelPattern.startsWith("/")) {
                        typeLevelPattern = "/" + typeLevelPattern;
                    }
                    if ((matchingPattern2 = this.getMatchingPattern(combinedPattern2 = AnnotationMethodHandlerAdapter.this.pathMatcher.combine(typeLevelPattern, methodLevelPattern), lookupPath, useSuffixPattern)) == null) continue;
                    return matchingPattern2;
                }
                return null;
            }
            String bestMatchingPattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
            if (StringUtils.hasText((String)bestMatchingPattern) && bestMatchingPattern.endsWith("*") && (matchingPattern = this.getMatchingPattern(combinedPattern = AnnotationMethodHandlerAdapter.this.pathMatcher.combine(bestMatchingPattern, methodLevelPattern), lookupPath, useSuffixPattern)) != null && !matchingPattern.equals(bestMatchingPattern)) {
                return matchingPattern;
            }
            return this.getMatchingPattern(methodLevelPattern, lookupPath, useSuffixPattern);
        }

        private String getMatchingPattern(String pattern, String lookupPath, boolean useSuffixPattern) {
            boolean hasSuffix;
            if (pattern.equals(lookupPath)) {
                return pattern;
            }
            boolean bl = hasSuffix = pattern.indexOf(46) != -1;
            if (useSuffixPattern && !hasSuffix) {
                String patternWithSuffix = pattern + ".*";
                if (AnnotationMethodHandlerAdapter.this.pathMatcher.match(patternWithSuffix, lookupPath)) {
                    return patternWithSuffix;
                }
            }
            if (AnnotationMethodHandlerAdapter.this.pathMatcher.match(pattern, lookupPath)) {
                return pattern;
            }
            boolean endsWithSlash = pattern.endsWith("/");
            if (useSuffixPattern && !endsWithSlash) {
                String patternWithSlash = pattern + "/";
                if (AnnotationMethodHandlerAdapter.this.pathMatcher.match(patternWithSlash, lookupPath)) {
                    return patternWithSlash;
                }
            }
            return null;
        }

        private void extractHandlerMethodUriTemplates(String mappedPattern, String lookupPath, HttpServletRequest request) {
            Map variables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            int patternVariableCount = StringUtils.countOccurrencesOf((String)mappedPattern, (String)"{");
            if ((variables == null || patternVariableCount != variables.size()) && AnnotationMethodHandlerAdapter.this.pathMatcher.match(mappedPattern, lookupPath)) {
                variables = AnnotationMethodHandlerAdapter.this.pathMatcher.extractUriTemplateVariables(mappedPattern, lookupPath);
                Map decodedVariables = AnnotationMethodHandlerAdapter.this.urlPathHelper.decodePathVariables(request, variables);
                request.setAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, (Object)decodedVariables);
            }
        }
    }
}

