/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.http.MediaType;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationManagerFactoryBean;
import org.springframework.web.accept.ContentNegotiationStrategy;

public class ContentNegotiationConfigurer {
    private final ContentNegotiationManagerFactoryBean factoryBean = new ContentNegotiationManagerFactoryBean();
    private final Map<String, MediaType> mediaTypes = new HashMap<String, MediaType>();

    public ContentNegotiationConfigurer(ServletContext servletContext) {
        this.factoryBean.setServletContext(servletContext);
    }

    public ContentNegotiationConfigurer favorPathExtension(boolean favorPathExtension) {
        this.factoryBean.setFavorPathExtension(favorPathExtension);
        return this;
    }

    public ContentNegotiationConfigurer mediaType(String extension, MediaType mediaType) {
        this.mediaTypes.put(extension, mediaType);
        return this;
    }

    public ContentNegotiationConfigurer mediaTypes(Map<String, MediaType> mediaTypes) {
        if (mediaTypes != null) {
            this.mediaTypes.putAll(mediaTypes);
        }
        return this;
    }

    public ContentNegotiationConfigurer replaceMediaTypes(Map<String, MediaType> mediaTypes) {
        this.mediaTypes.clear();
        this.mediaTypes(mediaTypes);
        return this;
    }

    public ContentNegotiationConfigurer ignoreUnknownPathExtensions(boolean ignore) {
        this.factoryBean.setIgnoreUnknownPathExtensions(ignore);
        return this;
    }

    public ContentNegotiationConfigurer useJaf(boolean useJaf) {
        this.factoryBean.setUseJaf(useJaf);
        return this;
    }

    public ContentNegotiationConfigurer favorParameter(boolean favorParameter) {
        this.factoryBean.setFavorParameter(favorParameter);
        return this;
    }

    public ContentNegotiationConfigurer parameterName(String parameterName) {
        this.factoryBean.setParameterName(parameterName);
        return this;
    }

    public ContentNegotiationConfigurer ignoreAcceptHeader(boolean ignoreAcceptHeader) {
        this.factoryBean.setIgnoreAcceptHeader(ignoreAcceptHeader);
        return this;
    }

    public ContentNegotiationConfigurer defaultContentType(MediaType defaultContentType) {
        this.factoryBean.setDefaultContentType(defaultContentType);
        return this;
    }

    public ContentNegotiationConfigurer defaultContentTypeStrategy(ContentNegotiationStrategy defaultStrategy) {
        this.factoryBean.setDefaultContentTypeStrategy(defaultStrategy);
        return this;
    }

    protected ContentNegotiationManager getContentNegotiationManager() throws Exception {
        if (!this.mediaTypes.isEmpty()) {
            this.factoryBean.addMediaTypes(this.mediaTypes);
        }
        this.factoryBean.afterPropertiesSet();
        return this.factoryBean.getObject();
    }
}

