/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.core.ExceptionDepthComparator;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.converter.xml.XmlAwareFormHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.support.RequestContextUtils;

@Deprecated
public class AnnotationMethodHandlerExceptionResolver
extends AbstractHandlerExceptionResolver {
    private static final Method NO_METHOD_FOUND = ClassUtils.getMethodIfAvailable(System.class, (String)"currentTimeMillis", (Class[])null);
    private final Map<Class<?>, Map<Class<? extends Throwable>, Method>> exceptionHandlerCache = new ConcurrentHashMap(64);
    private WebArgumentResolver[] customArgumentResolvers;
    private HttpMessageConverter<?>[] messageConverters = new HttpMessageConverter[]{new ByteArrayHttpMessageConverter(), new StringHttpMessageConverter(), new SourceHttpMessageConverter(), new XmlAwareFormHttpMessageConverter()};

    public void setCustomArgumentResolver(WebArgumentResolver argumentResolver) {
        this.customArgumentResolvers = new WebArgumentResolver[]{argumentResolver};
    }

    public void setCustomArgumentResolvers(WebArgumentResolver[] argumentResolvers) {
        this.customArgumentResolvers = argumentResolvers;
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    @Override
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        Method handlerMethod;
        if (handler != null && (handlerMethod = this.findBestExceptionHandlerMethod(handler, ex)) != null) {
            ServletWebRequest webRequest = new ServletWebRequest(request, response);
            try {
                Object[] args = this.resolveHandlerArguments(handlerMethod, handler, (NativeWebRequest)webRequest, ex);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking request handler method: " + handlerMethod));
                }
                Object retVal = this.doInvokeMethod(handlerMethod, handler, args);
                return this.getModelAndView(handlerMethod, retVal, webRequest);
            }
            catch (Exception invocationEx) {
                this.logger.error((Object)("Invoking request method resulted in exception : " + handlerMethod), (Throwable)invocationEx);
            }
        }
        return null;
    }

    private Method findBestExceptionHandlerMethod(Object handler, Exception thrownException) {
        final Class handlerType = ClassUtils.getUserClass((Object)handler);
        final Class<?> thrownExceptionType = thrownException.getClass();
        Method handlerMethod = null;
        Map<Class<? extends Throwable>, Method> handlers = this.exceptionHandlerCache.get(handlerType);
        if (handlers != null) {
            handlerMethod = handlers.get(thrownExceptionType);
            if (handlerMethod != null) {
                return handlerMethod == NO_METHOD_FOUND ? null : handlerMethod;
            }
        } else {
            handlers = new ConcurrentHashMap<Class<? extends Throwable>, Method>(16);
            this.exceptionHandlerCache.put(handlerType, handlers);
        }
        final HashMap<Class<? extends Throwable>, Method> matchedHandlers = new HashMap<Class<? extends Throwable>, Method>();
        ReflectionUtils.doWithMethods((Class)handlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                method = ClassUtils.getMostSpecificMethod((Method)method, (Class)handlerType);
                List<Class<? extends Throwable>> handledExceptions = AnnotationMethodHandlerExceptionResolver.this.getHandledExceptions(method);
                for (Class<? extends Throwable> handledException : handledExceptions) {
                    if (!handledException.isAssignableFrom(thrownExceptionType)) continue;
                    if (!matchedHandlers.containsKey(handledException)) {
                        matchedHandlers.put(handledException, method);
                        continue;
                    }
                    Method oldMappedMethod = (Method)matchedHandlers.get(handledException);
                    if (oldMappedMethod.equals(method)) continue;
                    throw new IllegalStateException("Ambiguous exception handler mapped for " + handledException + "]: {" + oldMappedMethod + ", " + method + "}.");
                }
            }
        });
        handlerMethod = this.getBestMatchingMethod(matchedHandlers, thrownException);
        handlers.put(thrownExceptionType, handlerMethod == null ? NO_METHOD_FOUND : handlerMethod);
        return handlerMethod;
    }

    protected List<Class<? extends Throwable>> getHandledExceptions(Method method) {
        ArrayList<Class<? extends Throwable>> result = new ArrayList<Class<? extends Throwable>>();
        ExceptionHandler exceptionHandler = (ExceptionHandler)AnnotationUtils.findAnnotation((Method)method, ExceptionHandler.class);
        if (exceptionHandler != null) {
            if (!ObjectUtils.isEmpty((Object[])exceptionHandler.value())) {
                result.addAll(Arrays.asList(exceptionHandler.value()));
            } else {
                for (Class<?> param : method.getParameterTypes()) {
                    if (!Throwable.class.isAssignableFrom(param)) continue;
                    result.add(param);
                }
            }
        }
        return result;
    }

    private Method getBestMatchingMethod(Map<Class<? extends Throwable>, Method> resolverMethods, Exception thrownException) {
        if (resolverMethods.isEmpty()) {
            return null;
        }
        Class closestMatch = ExceptionDepthComparator.findClosestMatch(resolverMethods.keySet(), (Throwable)thrownException);
        Method method = resolverMethods.get(closestMatch);
        return method == null || NO_METHOD_FOUND == method ? null : method;
    }

    private Object[] resolveHandlerArguments(Method handlerMethod, Object handler, NativeWebRequest webRequest, Exception thrownException) throws Exception {
        Class<?>[] paramTypes = handlerMethod.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        Class<?> handlerType = handler.getClass();
        for (int i = 0; i < args.length; ++i) {
            SynthesizingMethodParameter methodParam = new SynthesizingMethodParameter(handlerMethod, i);
            GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, handlerType);
            Class paramType = methodParam.getParameterType();
            Object argValue = this.resolveCommonArgument((MethodParameter)methodParam, webRequest, thrownException);
            if (argValue == WebArgumentResolver.UNRESOLVED) {
                throw new IllegalStateException("Unsupported argument [" + paramType.getName() + "] for @ExceptionHandler method: " + handlerMethod);
            }
            args[i] = argValue;
        }
        return args;
    }

    protected Object resolveCommonArgument(MethodParameter methodParameter, NativeWebRequest webRequest, Exception thrownException) throws Exception {
        Class paramType;
        Object value;
        if (this.customArgumentResolvers != null) {
            for (WebArgumentResolver argumentResolver : this.customArgumentResolvers) {
                Object value2 = argumentResolver.resolveArgument(methodParameter, webRequest);
                if (value2 == WebArgumentResolver.UNRESOLVED) continue;
                return value2;
            }
        }
        if ((value = this.resolveStandardArgument(paramType = methodParameter.getParameterType(), webRequest, thrownException)) != WebArgumentResolver.UNRESOLVED && !ClassUtils.isAssignableValue((Class)paramType, (Object)value)) {
            throw new IllegalStateException("Standard argument type [" + paramType.getName() + "] resolved to incompatible value of type [" + (value != null ? value.getClass() : null) + "]. Consider declaring the argument type in a less specific fashion.");
        }
        return value;
    }

    protected Object resolveStandardArgument(Class<?> parameterType, NativeWebRequest webRequest, Exception thrownException) throws Exception {
        if (parameterType.isInstance(thrownException)) {
            return thrownException;
        }
        if (WebRequest.class.isAssignableFrom(parameterType)) {
            return webRequest;
        }
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        if (ServletRequest.class.isAssignableFrom(parameterType)) {
            return request;
        }
        if (ServletResponse.class.isAssignableFrom(parameterType)) {
            return response;
        }
        if (HttpSession.class.isAssignableFrom(parameterType)) {
            return request.getSession();
        }
        if (Principal.class.isAssignableFrom(parameterType)) {
            return request.getUserPrincipal();
        }
        if (Locale.class == parameterType) {
            return RequestContextUtils.getLocale(request);
        }
        if (InputStream.class.isAssignableFrom(parameterType)) {
            return request.getInputStream();
        }
        if (Reader.class.isAssignableFrom(parameterType)) {
            return request.getReader();
        }
        if (OutputStream.class.isAssignableFrom(parameterType)) {
            return response.getOutputStream();
        }
        if (Writer.class.isAssignableFrom(parameterType)) {
            return response.getWriter();
        }
        return WebArgumentResolver.UNRESOLVED;
    }

    private Object doInvokeMethod(Method method, Object target, Object[] args) throws Exception {
        ReflectionUtils.makeAccessible((Method)method);
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            ReflectionUtils.rethrowException((Throwable)ex.getTargetException());
            throw new IllegalStateException("Should never get here");
        }
    }

    private ModelAndView getModelAndView(Method handlerMethod, Object returnValue, ServletWebRequest webRequest) throws Exception {
        ResponseStatus responseStatusAnn = (ResponseStatus)AnnotationUtils.findAnnotation((Method)handlerMethod, ResponseStatus.class);
        if (responseStatusAnn != null) {
            HttpStatus responseStatus = responseStatusAnn.code();
            String reason = responseStatusAnn.reason();
            if (!StringUtils.hasText((String)reason)) {
                webRequest.getResponse().setStatus(responseStatus.value());
            } else {
                webRequest.getResponse().sendError(responseStatus.value(), reason);
            }
        }
        if (returnValue != null && AnnotationUtils.findAnnotation((Method)handlerMethod, ResponseBody.class) != null) {
            return this.handleResponseBody(returnValue, webRequest);
        }
        if (returnValue instanceof ModelAndView) {
            return (ModelAndView)returnValue;
        }
        if (returnValue instanceof Model) {
            return new ModelAndView().addAllObjects(((Model)returnValue).asMap());
        }
        if (returnValue instanceof Map) {
            return new ModelAndView().addAllObjects((Map)returnValue);
        }
        if (returnValue instanceof View) {
            return new ModelAndView((View)returnValue);
        }
        if (returnValue instanceof String) {
            return new ModelAndView((String)returnValue);
        }
        if (returnValue == null) {
            return new ModelAndView();
        }
        throw new IllegalArgumentException("Invalid handler method return value: " + returnValue);
    }

    private ModelAndView handleResponseBody(Object returnValue, ServletWebRequest webRequest) throws ServletException, IOException {
        ServletServerHttpRequest inputMessage = new ServletServerHttpRequest(webRequest.getRequest());
        List<MediaType> acceptedMediaTypes = inputMessage.getHeaders().getAccept();
        if (acceptedMediaTypes.isEmpty()) {
            acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
        }
        MediaType.sortByQualityValue((List)acceptedMediaTypes);
        ServletServerHttpResponse outputMessage = new ServletServerHttpResponse(webRequest.getResponse());
        Class<?> returnValueType = returnValue.getClass();
        if (this.messageConverters != null) {
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                for (HttpMessageConverter<?> messageConverter : this.messageConverters) {
                    if (!messageConverter.canWrite(returnValueType, acceptedMediaType)) continue;
                    messageConverter.write(returnValue, acceptedMediaType, (HttpOutputMessage)outputMessage);
                    return new ModelAndView();
                }
            }
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Could not find HttpMessageConverter that supports return type [" + returnValueType + "] and " + acceptedMediaTypes));
        }
        return null;
    }
}

