/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.FormattingConversionServiceFactoryBean;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperFactoryBean;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.accept.ContentNegotiationManagerFactoryBean;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.method.support.CompositeUriComponentsContributor;
import org.springframework.web.servlet.config.MvcNamespaceUtils;
import org.springframework.web.servlet.handler.ConversionServiceExposingInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.mvc.annotation.ResponseStatusExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.JsonViewRequestBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.JsonViewResponseBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.ServletWebArgumentResolverAdapter;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;
import org.w3c.dom.Element;

class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String HANDLER_MAPPING_BEAN_NAME = RequestMappingHandlerMapping.class.getName();
    public static final String HANDLER_ADAPTER_BEAN_NAME = RequestMappingHandlerAdapter.class.getName();
    public static final String CONTENT_NEGOTIATION_MANAGER_BEAN_NAME = "mvcContentNegotiationManager";
    private static final boolean javaxValidationPresent = ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static boolean romePresent = ClassUtils.isPresent((String)"com.rometools.rome.feed.WireFeed", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean jackson2XmlPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.xml.XmlMapper", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean gsonPresent = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());

    AnnotationDrivenBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Boolean ignoreDefaultModel;
        Boolean enableMatrixVariables;
        Object source = parserContext.extractSource((Object)element);
        XmlReaderContext readerContext = parserContext.getReaderContext();
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserContext.pushContainingComponent(compDefinition);
        RuntimeBeanReference contentNegotiationManager = this.getContentNegotiationManager(element, source, parserContext);
        RootBeanDefinition handlerMappingDef = new RootBeanDefinition(RequestMappingHandlerMapping.class);
        handlerMappingDef.setSource(source);
        handlerMappingDef.setRole(2);
        handlerMappingDef.getPropertyValues().add("order", (Object)0);
        handlerMappingDef.getPropertyValues().add("contentNegotiationManager", (Object)contentNegotiationManager);
        if (element.hasAttribute("enable-matrix-variables")) {
            enableMatrixVariables = Boolean.valueOf(element.getAttribute("enable-matrix-variables"));
            handlerMappingDef.getPropertyValues().add("removeSemicolonContent", (Object)(enableMatrixVariables == false ? 1 : 0));
        } else if (element.hasAttribute("enableMatrixVariables")) {
            enableMatrixVariables = Boolean.valueOf(element.getAttribute("enableMatrixVariables"));
            handlerMappingDef.getPropertyValues().add("removeSemicolonContent", (Object)(enableMatrixVariables == false ? 1 : 0));
        }
        this.configurePathMatchingProperties(handlerMappingDef, element, parserContext);
        readerContext.getRegistry().registerBeanDefinition(HANDLER_MAPPING_BEAN_NAME, (BeanDefinition)handlerMappingDef);
        RuntimeBeanReference corsConfigurationsRef = MvcNamespaceUtils.registerCorsConfigurations(null, parserContext, source);
        handlerMappingDef.getPropertyValues().add("corsConfigurations", (Object)corsConfigurationsRef);
        RuntimeBeanReference conversionService = this.getConversionService(element, source, parserContext);
        RuntimeBeanReference validator = this.getValidator(element, source, parserContext);
        RuntimeBeanReference messageCodesResolver = this.getMessageCodesResolver(element);
        RootBeanDefinition bindingDef = new RootBeanDefinition(ConfigurableWebBindingInitializer.class);
        bindingDef.setSource(source);
        bindingDef.setRole(2);
        bindingDef.getPropertyValues().add("conversionService", (Object)conversionService);
        bindingDef.getPropertyValues().add("validator", (Object)validator);
        bindingDef.getPropertyValues().add("messageCodesResolver", (Object)messageCodesResolver);
        ManagedList<?> messageConverters = this.getMessageConverters(element, source, parserContext);
        ManagedList<?> argumentResolvers = this.getArgumentResolvers(element, parserContext);
        ManagedList<?> returnValueHandlers = this.getReturnValueHandlers(element, parserContext);
        String asyncTimeout = this.getAsyncTimeout(element);
        RuntimeBeanReference asyncExecutor = this.getAsyncExecutor(element);
        ManagedList<?> callableInterceptors = this.getCallableInterceptors(element, source, parserContext);
        ManagedList<?> deferredResultInterceptors = this.getDeferredResultInterceptors(element, source, parserContext);
        RootBeanDefinition handlerAdapterDef = new RootBeanDefinition(RequestMappingHandlerAdapter.class);
        handlerAdapterDef.setSource(source);
        handlerAdapterDef.setRole(2);
        handlerAdapterDef.getPropertyValues().add("contentNegotiationManager", (Object)contentNegotiationManager);
        handlerAdapterDef.getPropertyValues().add("webBindingInitializer", (Object)bindingDef);
        handlerAdapterDef.getPropertyValues().add("messageConverters", messageConverters);
        this.addRequestBodyAdvice(handlerAdapterDef);
        this.addResponseBodyAdvice(handlerAdapterDef);
        if (element.hasAttribute("ignore-default-model-on-redirect")) {
            ignoreDefaultModel = Boolean.valueOf(element.getAttribute("ignore-default-model-on-redirect"));
            handlerAdapterDef.getPropertyValues().add("ignoreDefaultModelOnRedirect", (Object)ignoreDefaultModel);
        } else if (element.hasAttribute("ignoreDefaultModelOnRedirect")) {
            ignoreDefaultModel = Boolean.valueOf(element.getAttribute("ignoreDefaultModelOnRedirect"));
            handlerAdapterDef.getPropertyValues().add("ignoreDefaultModelOnRedirect", (Object)ignoreDefaultModel);
        }
        if (argumentResolvers != null) {
            handlerAdapterDef.getPropertyValues().add("customArgumentResolvers", argumentResolvers);
        }
        if (returnValueHandlers != null) {
            handlerAdapterDef.getPropertyValues().add("customReturnValueHandlers", returnValueHandlers);
        }
        if (asyncTimeout != null) {
            handlerAdapterDef.getPropertyValues().add("asyncRequestTimeout", (Object)asyncTimeout);
        }
        if (asyncExecutor != null) {
            handlerAdapterDef.getPropertyValues().add("taskExecutor", (Object)asyncExecutor);
        }
        handlerAdapterDef.getPropertyValues().add("callableInterceptors", callableInterceptors);
        handlerAdapterDef.getPropertyValues().add("deferredResultInterceptors", deferredResultInterceptors);
        readerContext.getRegistry().registerBeanDefinition(HANDLER_ADAPTER_BEAN_NAME, (BeanDefinition)handlerAdapterDef);
        String uriCompContribName = "mvcUriComponentsContributor";
        RootBeanDefinition uriCompContribDef = new RootBeanDefinition(CompositeUriComponentsContributorFactoryBean.class);
        uriCompContribDef.setSource(source);
        uriCompContribDef.getPropertyValues().addPropertyValue("handlerAdapter", (Object)handlerAdapterDef);
        uriCompContribDef.getPropertyValues().addPropertyValue("conversionService", (Object)conversionService);
        readerContext.getRegistry().registerBeanDefinition(uriCompContribName, (BeanDefinition)uriCompContribDef);
        RootBeanDefinition csInterceptorDef = new RootBeanDefinition(ConversionServiceExposingInterceptor.class);
        csInterceptorDef.setSource(source);
        csInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)conversionService);
        RootBeanDefinition mappedCsInterceptorDef = new RootBeanDefinition(MappedInterceptor.class);
        mappedCsInterceptorDef.setSource(source);
        mappedCsInterceptorDef.setRole(2);
        mappedCsInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, null);
        mappedCsInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)csInterceptorDef);
        String mappedInterceptorName = readerContext.registerWithGeneratedName((BeanDefinition)mappedCsInterceptorDef);
        RootBeanDefinition exceptionHandlerExceptionResolver = new RootBeanDefinition(ExceptionHandlerExceptionResolver.class);
        exceptionHandlerExceptionResolver.setSource(source);
        exceptionHandlerExceptionResolver.setRole(2);
        exceptionHandlerExceptionResolver.getPropertyValues().add("contentNegotiationManager", (Object)contentNegotiationManager);
        exceptionHandlerExceptionResolver.getPropertyValues().add("messageConverters", messageConverters);
        exceptionHandlerExceptionResolver.getPropertyValues().add("order", (Object)0);
        this.addResponseBodyAdvice(exceptionHandlerExceptionResolver);
        String methodExceptionResolverName = readerContext.registerWithGeneratedName((BeanDefinition)exceptionHandlerExceptionResolver);
        RootBeanDefinition responseStatusExceptionResolver = new RootBeanDefinition(ResponseStatusExceptionResolver.class);
        responseStatusExceptionResolver.setSource(source);
        responseStatusExceptionResolver.setRole(2);
        responseStatusExceptionResolver.getPropertyValues().add("order", (Object)1);
        String responseStatusExceptionResolverName = readerContext.registerWithGeneratedName((BeanDefinition)responseStatusExceptionResolver);
        RootBeanDefinition defaultExceptionResolver = new RootBeanDefinition(DefaultHandlerExceptionResolver.class);
        defaultExceptionResolver.setSource(source);
        defaultExceptionResolver.setRole(2);
        defaultExceptionResolver.getPropertyValues().add("order", (Object)2);
        String defaultExceptionResolverName = readerContext.registerWithGeneratedName((BeanDefinition)defaultExceptionResolver);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerMappingDef, HANDLER_MAPPING_BEAN_NAME));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)handlerAdapterDef, HANDLER_ADAPTER_BEAN_NAME));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)uriCompContribDef, uriCompContribName));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)exceptionHandlerExceptionResolver, methodExceptionResolverName));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)responseStatusExceptionResolver, responseStatusExceptionResolverName));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)defaultExceptionResolver, defaultExceptionResolverName));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)mappedCsInterceptorDef, mappedInterceptorName));
        MvcNamespaceUtils.registerDefaultComponents(parserContext, source);
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    protected void addRequestBodyAdvice(RootBeanDefinition beanDef) {
        if (jackson2Present) {
            beanDef.getPropertyValues().add("requestBodyAdvice", (Object)new RootBeanDefinition(JsonViewRequestBodyAdvice.class));
        }
    }

    protected void addResponseBodyAdvice(RootBeanDefinition beanDef) {
        if (jackson2Present) {
            beanDef.getPropertyValues().add("responseBodyAdvice", (Object)new RootBeanDefinition(JsonViewResponseBodyAdvice.class));
        }
    }

    private RuntimeBeanReference getConversionService(Element element, Object source, ParserContext parserContext) {
        RuntimeBeanReference conversionServiceRef;
        if (element.hasAttribute("conversion-service")) {
            conversionServiceRef = new RuntimeBeanReference(element.getAttribute("conversion-service"));
        } else {
            RootBeanDefinition conversionDef = new RootBeanDefinition(FormattingConversionServiceFactoryBean.class);
            conversionDef.setSource(source);
            conversionDef.setRole(2);
            String conversionName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)conversionDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)conversionDef, conversionName));
            conversionServiceRef = new RuntimeBeanReference(conversionName);
        }
        return conversionServiceRef;
    }

    private RuntimeBeanReference getValidator(Element element, Object source, ParserContext parserContext) {
        if (element.hasAttribute("validator")) {
            return new RuntimeBeanReference(element.getAttribute("validator"));
        }
        if (javaxValidationPresent) {
            RootBeanDefinition validatorDef = new RootBeanDefinition("org.springframework.validation.beanvalidation.OptionalValidatorFactoryBean");
            validatorDef.setSource(source);
            validatorDef.setRole(2);
            String validatorName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)validatorDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)validatorDef, validatorName));
            return new RuntimeBeanReference(validatorName);
        }
        return null;
    }

    private RuntimeBeanReference getContentNegotiationManager(Element element, Object source, ParserContext parserContext) {
        RuntimeBeanReference beanRef;
        if (element.hasAttribute("content-negotiation-manager")) {
            String name = element.getAttribute("content-negotiation-manager");
            beanRef = new RuntimeBeanReference(name);
        } else {
            RootBeanDefinition factoryBeanDef = new RootBeanDefinition(ContentNegotiationManagerFactoryBean.class);
            factoryBeanDef.setSource(source);
            factoryBeanDef.setRole(2);
            factoryBeanDef.getPropertyValues().add("mediaTypes", (Object)this.getDefaultMediaTypes());
            String name = CONTENT_NEGOTIATION_MANAGER_BEAN_NAME;
            parserContext.getReaderContext().getRegistry().registerBeanDefinition(name, (BeanDefinition)factoryBeanDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)factoryBeanDef, name));
            beanRef = new RuntimeBeanReference(name);
        }
        return beanRef;
    }

    private void configurePathMatchingProperties(RootBeanDefinition handlerMappingDef, Element element, ParserContext parserContext) {
        Element pathMatchingElement = DomUtils.getChildElementByTagName((Element)element, (String)"path-matching");
        if (pathMatchingElement != null) {
            Object source = parserContext.extractSource((Object)element);
            if (pathMatchingElement.hasAttribute("suffix-pattern")) {
                Boolean useSuffixPatternMatch = Boolean.valueOf(pathMatchingElement.getAttribute("suffix-pattern"));
                handlerMappingDef.getPropertyValues().add("useSuffixPatternMatch", (Object)useSuffixPatternMatch);
            }
            if (pathMatchingElement.hasAttribute("trailing-slash")) {
                Boolean useTrailingSlashMatch = Boolean.valueOf(pathMatchingElement.getAttribute("trailing-slash"));
                handlerMappingDef.getPropertyValues().add("useTrailingSlashMatch", (Object)useTrailingSlashMatch);
            }
            if (pathMatchingElement.hasAttribute("registered-suffixes-only")) {
                Boolean useRegisteredSuffixPatternMatch = Boolean.valueOf(pathMatchingElement.getAttribute("registered-suffixes-only"));
                handlerMappingDef.getPropertyValues().add("useRegisteredSuffixPatternMatch", (Object)useRegisteredSuffixPatternMatch);
            }
            RuntimeBeanReference pathHelperRef = null;
            if (pathMatchingElement.hasAttribute("path-helper")) {
                pathHelperRef = new RuntimeBeanReference(pathMatchingElement.getAttribute("path-helper"));
            }
            pathHelperRef = MvcNamespaceUtils.registerUrlPathHelper(pathHelperRef, parserContext, source);
            handlerMappingDef.getPropertyValues().add("urlPathHelper", (Object)pathHelperRef);
            RuntimeBeanReference pathMatcherRef = null;
            if (pathMatchingElement.hasAttribute("path-matcher")) {
                pathMatcherRef = new RuntimeBeanReference(pathMatchingElement.getAttribute("path-matcher"));
            }
            pathMatcherRef = MvcNamespaceUtils.registerPathMatcher(pathMatcherRef, parserContext, source);
            handlerMappingDef.getPropertyValues().add("pathMatcher", (Object)pathMatcherRef);
        }
    }

    private Properties getDefaultMediaTypes() {
        Properties props = new Properties();
        if (romePresent) {
            props.put("atom", "application/atom+xml");
            props.put("rss", "application/rss+xml");
        }
        if (jaxb2Present || jackson2XmlPresent) {
            props.put("xml", "application/xml");
        }
        if (jackson2Present || gsonPresent) {
            props.put("json", "application/json");
        }
        return props;
    }

    private RuntimeBeanReference getMessageCodesResolver(Element element) {
        if (element.hasAttribute("message-codes-resolver")) {
            return new RuntimeBeanReference(element.getAttribute("message-codes-resolver"));
        }
        return null;
    }

    private String getAsyncTimeout(Element element) {
        Element asyncElement = DomUtils.getChildElementByTagName((Element)element, (String)"async-support");
        return asyncElement != null ? asyncElement.getAttribute("default-timeout") : null;
    }

    private RuntimeBeanReference getAsyncExecutor(Element element) {
        Element asyncElement = DomUtils.getChildElementByTagName((Element)element, (String)"async-support");
        if (asyncElement != null && asyncElement.hasAttribute("task-executor")) {
            return new RuntimeBeanReference(asyncElement.getAttribute("task-executor"));
        }
        return null;
    }

    private ManagedList<?> getCallableInterceptors(Element element, Object source, ParserContext parserContext) {
        Element interceptorsElement;
        ManagedList interceptors = new ManagedList();
        Element asyncElement = DomUtils.getChildElementByTagName((Element)element, (String)"async-support");
        if (asyncElement != null && (interceptorsElement = DomUtils.getChildElementByTagName((Element)asyncElement, (String)"callable-interceptors")) != null) {
            interceptors.setSource(source);
            for (Element converter : DomUtils.getChildElementsByTagName((Element)interceptorsElement, (String)"bean")) {
                BeanDefinitionHolder beanDef = parserContext.getDelegate().parseBeanDefinitionElement(converter);
                beanDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(converter, beanDef);
                interceptors.add((Object)beanDef);
            }
        }
        return interceptors;
    }

    private ManagedList<?> getDeferredResultInterceptors(Element element, Object source, ParserContext parserContext) {
        Element interceptorsElement;
        ManagedList interceptors = new ManagedList();
        Element asyncElement = DomUtils.getChildElementByTagName((Element)element, (String)"async-support");
        if (asyncElement != null && (interceptorsElement = DomUtils.getChildElementByTagName((Element)asyncElement, (String)"deferred-result-interceptors")) != null) {
            interceptors.setSource(source);
            for (Element converter : DomUtils.getChildElementsByTagName((Element)interceptorsElement, (String)"bean")) {
                BeanDefinitionHolder beanDef = parserContext.getDelegate().parseBeanDefinitionElement(converter);
                beanDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(converter, beanDef);
                interceptors.add((Object)beanDef);
            }
        }
        return interceptors;
    }

    private ManagedList<?> getArgumentResolvers(Element element, ParserContext parserContext) {
        Element resolversElement = DomUtils.getChildElementByTagName((Element)element, (String)"argument-resolvers");
        if (resolversElement != null) {
            ManagedList<Object> resolvers = this.extractBeanSubElements(resolversElement, parserContext);
            return this.wrapLegacyResolvers((List<Object>)resolvers, parserContext);
        }
        return null;
    }

    private ManagedList<Object> wrapLegacyResolvers(List<Object> list, ParserContext context) {
        ManagedList result = new ManagedList();
        for (Object object : list) {
            BeanDefinitionHolder beanDef;
            String className;
            Class clazz;
            if (object instanceof BeanDefinitionHolder && WebArgumentResolver.class.isAssignableFrom(clazz = ClassUtils.resolveClassName((String)(className = (beanDef = (BeanDefinitionHolder)object).getBeanDefinition().getBeanClassName()), (ClassLoader)context.getReaderContext().getBeanClassLoader()))) {
                RootBeanDefinition adapter = new RootBeanDefinition(ServletWebArgumentResolverAdapter.class);
                adapter.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)beanDef);
                result.add((Object)new BeanDefinitionHolder((BeanDefinition)adapter, beanDef.getBeanName() + "Adapter"));
                continue;
            }
            result.add(object);
        }
        return result;
    }

    private ManagedList<?> getReturnValueHandlers(Element element, ParserContext parserContext) {
        Element handlers = DomUtils.getChildElementByTagName((Element)element, (String)"return-value-handlers");
        return handlers != null ? this.extractBeanSubElements(handlers, parserContext) : null;
    }

    private ManagedList<?> getMessageConverters(Element element, Object source, ParserContext parserContext) {
        Element convertersElement = DomUtils.getChildElementByTagName((Element)element, (String)"message-converters");
        ManagedList messageConverters = new ManagedList();
        if (convertersElement != null) {
            messageConverters.setSource(source);
            for (Element beanElement : DomUtils.getChildElementsByTagName((Element)convertersElement, (String[])new String[]{"bean", "ref"})) {
                Object object = parserContext.getDelegate().parsePropertySubElement(beanElement, null);
                messageConverters.add(object);
            }
        }
        if (convertersElement == null || Boolean.valueOf(convertersElement.getAttribute("register-defaults")).booleanValue()) {
            GenericBeanDefinition jacksonFactoryDef;
            RootBeanDefinition jacksonConverterDef;
            messageConverters.setSource(source);
            messageConverters.add((Object)this.createConverterDefinition(ByteArrayHttpMessageConverter.class, source));
            RootBeanDefinition stringConverterDef = this.createConverterDefinition(StringHttpMessageConverter.class, source);
            stringConverterDef.getPropertyValues().add("writeAcceptCharset", (Object)false);
            messageConverters.add((Object)stringConverterDef);
            messageConverters.add((Object)this.createConverterDefinition(ResourceHttpMessageConverter.class, source));
            messageConverters.add((Object)this.createConverterDefinition(SourceHttpMessageConverter.class, source));
            messageConverters.add((Object)this.createConverterDefinition(AllEncompassingFormHttpMessageConverter.class, source));
            if (romePresent) {
                messageConverters.add((Object)this.createConverterDefinition(AtomFeedHttpMessageConverter.class, source));
                messageConverters.add((Object)this.createConverterDefinition(RssChannelHttpMessageConverter.class, source));
            }
            if (jackson2XmlPresent) {
                jacksonConverterDef = this.createConverterDefinition(MappingJackson2XmlHttpMessageConverter.class, source);
                jacksonFactoryDef = this.createObjectMapperFactoryDefinition(source);
                jacksonFactoryDef.getPropertyValues().add("createXmlMapper", (Object)true);
                jacksonConverterDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)jacksonFactoryDef);
                messageConverters.add((Object)jacksonConverterDef);
            } else if (jaxb2Present) {
                messageConverters.add((Object)this.createConverterDefinition(Jaxb2RootElementHttpMessageConverter.class, source));
            }
            if (jackson2Present) {
                jacksonConverterDef = this.createConverterDefinition(MappingJackson2HttpMessageConverter.class, source);
                jacksonFactoryDef = this.createObjectMapperFactoryDefinition(source);
                jacksonConverterDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)jacksonFactoryDef);
                messageConverters.add((Object)jacksonConverterDef);
            } else if (gsonPresent) {
                messageConverters.add((Object)this.createConverterDefinition(GsonHttpMessageConverter.class, source));
            }
        }
        return messageConverters;
    }

    private GenericBeanDefinition createObjectMapperFactoryDefinition(Object source) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(Jackson2ObjectMapperFactoryBean.class);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        return beanDefinition;
    }

    private RootBeanDefinition createConverterDefinition(Class<?> converterClass, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(converterClass);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        return beanDefinition;
    }

    private ManagedList<Object> extractBeanSubElements(Element parentElement, ParserContext parserContext) {
        ManagedList list = new ManagedList();
        list.setSource(parserContext.extractSource((Object)parentElement));
        for (Element beanElement : DomUtils.getChildElementsByTagName((Element)parentElement, (String[])new String[]{"bean", "ref"})) {
            Object object = parserContext.getDelegate().parsePropertySubElement(beanElement, null);
            list.add(object);
        }
        return list;
    }

    private ManagedList<BeanReference> extractBeanRefSubElements(Element parentElement, ParserContext parserContext) {
        ManagedList list = new ManagedList();
        list.setSource(parserContext.extractSource((Object)parentElement));
        for (Element refElement : DomUtils.getChildElementsByTagName((Element)parentElement, (String)"ref")) {
            RuntimeBeanReference reference;
            if (StringUtils.hasText((String)"bean")) {
                reference = new RuntimeBeanReference(refElement.getAttribute("bean"), false);
                list.add((Object)reference);
                continue;
            }
            if (StringUtils.hasText((String)"parent")) {
                reference = new RuntimeBeanReference(refElement.getAttribute("parent"), true);
                list.add((Object)reference);
                continue;
            }
            parserContext.getReaderContext().error("'bean' or 'parent' attribute is required for <ref> element", parserContext.extractSource((Object)parentElement));
        }
        return list;
    }

    static class CompositeUriComponentsContributorFactoryBean
    implements FactoryBean<CompositeUriComponentsContributor>,
    InitializingBean {
        private RequestMappingHandlerAdapter handlerAdapter;
        private ConversionService conversionService;
        private CompositeUriComponentsContributor uriComponentsContributor;

        CompositeUriComponentsContributorFactoryBean() {
        }

        public void setHandlerAdapter(RequestMappingHandlerAdapter handlerAdapter) {
            this.handlerAdapter = handlerAdapter;
        }

        public void setConversionService(ConversionService conversionService) {
            this.conversionService = conversionService;
        }

        public void afterPropertiesSet() {
            this.uriComponentsContributor = new CompositeUriComponentsContributor(this.handlerAdapter.getArgumentResolvers(), this.conversionService);
        }

        public CompositeUriComponentsContributor getObject() throws Exception {
            return this.uriComponentsContributor;
        }

        public Class<?> getObjectType() {
            return CompositeUriComponentsContributor.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

