/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springsource.loaded.Constants;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.TypeDescriptor;

public class IncrementalTypeDescriptor
implements Constants {
    private TypeDescriptor initialTypeDescriptor;
    private TypeDescriptor latestTypeDescriptor;
    private int bits;
    private static final int BIT_COMPUTED_DIFF = 1;
    private Map<String, MethodMember> latestMethods;
    private List<MethodMember> newOrChangedMethods;
    private List<MethodMember> newOrChangedConstructors;
    private List<MethodMember> deletedMethods;

    public IncrementalTypeDescriptor(TypeDescriptor initialTypeDescriptor) {
        this.reinitialize();
        this.initialTypeDescriptor = initialTypeDescriptor;
    }

    public TypeDescriptor getLatestTypeDescriptor() {
        return this.latestTypeDescriptor;
    }

    public void setLatestTypeDescriptor(TypeDescriptor typeDescriptor) {
        this.reinitialize();
        this.latestTypeDescriptor = typeDescriptor;
    }

    private void reinitialize() {
        this.bits = 0;
    }

    public List<MethodMember> getNewOrChangedMethods() {
        this.compute();
        return this.newOrChangedMethods;
    }

    public List<MethodMember> getNewOrChangedConstructors() {
        this.compute();
        return this.newOrChangedConstructors;
    }

    public List<MethodMember> getDeletedMethods() {
        this.compute();
        return this.deletedMethods;
    }

    private void compute() {
        if ((this.bits & 1) != 0) {
            return;
        }
        this.latestMethods = new HashMap<String, MethodMember>();
        this.newOrChangedMethods = new ArrayList<MethodMember>();
        this.deletedMethods = new ArrayList<MethodMember>();
        for (MethodMember latest : this.latestTypeDescriptor.getMethods()) {
            MethodMember original = this.initialTypeDescriptor.getByDescriptor(latest.getName(), latest.getDescriptor());
            if (original == null) {
                latest.bits |= 0x80;
                this.newOrChangedMethods.add(latest);
            } else {
                if (!original.equals(latest)) {
                    this.newOrChangedMethods.add(latest);
                }
                if (MethodMember.isCatcher(original) && !MethodMember.isCatcher(latest)) {
                    latest.bits |= 0x80;
                    this.newOrChangedMethods.add(latest);
                }
                if (MethodMember.isSuperDispatcher(original) && !MethodMember.isSuperDispatcher(latest)) {
                    latest.bits |= 0x80;
                    this.newOrChangedMethods.add(latest);
                }
                if (MethodMember.isCatcher(latest) && !MethodMember.isCatcher(original)) {
                    latest.bits |= 0x100;
                }
                latest.original = original;
                if (original.modifiers != latest.modifiers) {
                    int newVisibility;
                    int oldVisibility;
                    boolean isStatic;
                    boolean wasStatic = original.isStatic();
                    if (wasStatic != (isStatic = latest.isStatic())) {
                        latest.bits = wasStatic ? (latest.bits |= 0x20) : (latest.bits |= 0x10);
                    }
                    if ((oldVisibility = original.modifiers & 7) != (newVisibility = latest.modifiers & 7)) {
                        latest.bits |= 0x40;
                    }
                }
            }
            String nadKey = latest.getName() + latest.getDescriptor();
            this.latestMethods.put(nadKey, latest);
        }
        for (MethodMember initialMethod : this.initialTypeDescriptor.getMethods()) {
            if (MethodMember.isCatcher(initialMethod) || this.latestTypeDescriptor.defines(initialMethod)) continue;
            this.deletedMethods.add(initialMethod);
        }
        this.bits |= 1;
    }

    public boolean mustUseExecutorForThisMethod(int methodId) {
        this.compute();
        MethodMember method = this.initialTypeDescriptor.getMethod(methodId);
        if (MethodMember.isCatcher(method)) {
            boolean found = false;
            for (MethodMember method2 : this.newOrChangedMethods) {
                if (!method2.shouldReplace(method)) continue;
                found = true;
                if (!MethodMember.isCatcher(method2)) continue;
                return false;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    public boolean hasBeenDeleted(int methodId) {
        this.compute();
        MethodMember method = this.initialTypeDescriptor.getMethod(methodId);
        boolean a = false;
        for (MethodMember m : this.deletedMethods) {
            if (!m.equals(method)) continue;
            a = true;
            break;
        }
        return a;
    }

    public MethodMember getFromLatestByDescriptor(String nameAndDescriptor) {
        this.compute();
        return this.latestMethods.get(nameAndDescriptor);
    }

    public static boolean isBrandNewMethod(MethodMember mm) {
        return (mm.bits & 0x80) != 0;
    }

    public static boolean hasChanged(MethodMember mm) {
        return (mm.bits & Integer.MAX_VALUE) != 0;
    }

    public static boolean isCatcher(MethodMember method) {
        return (method.bits & 1) != 0;
    }

    public static boolean isNowNonStatic(MethodMember method) {
        return (method.bits & 0x20) != 0;
    }

    public static boolean isNowStatic(MethodMember method) {
        return (method.bits & 0x10) != 0;
    }

    public static boolean hasVisibilityChanged(MethodMember method) {
        return (method.bits & 0x40) != 0;
    }

    public static boolean wasDeleted(MethodMember method) {
        return (method.bits & 0x100) != 0;
    }

    public TypeDescriptor getOriginal() {
        return this.initialTypeDescriptor;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean compute) {
        StringBuilder s = new StringBuilder();
        s.append("Original:\n").append(this.initialTypeDescriptor).append("\nCurrent:\n").append(this.latestTypeDescriptor);
        s.append('\n');
        if (compute) {
            this.compute();
            s.append("Deleted methods: ").append(this.deletedMethods).append("\n");
            s.append("New or changed methods: ").append(this.newOrChangedMethods).append("\n");
        }
        return s.toString();
    }
}

