/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import org.springsource.loaded.Constants;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.Utils;
import sl.org.objectweb.asm.AnnotationVisitor;
import sl.org.objectweb.asm.Attribute;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.ClassWriter;
import sl.org.objectweb.asm.FieldVisitor;
import sl.org.objectweb.asm.MethodVisitor;

public class InterfaceExtractor {
    private TypeRegistry registry;

    public InterfaceExtractor(TypeRegistry registry) {
        this.registry = registry;
    }

    public static byte[] extract(byte[] classbytes, TypeRegistry registry, TypeDescriptor typeDescriptor) {
        return new InterfaceExtractor(registry).extract(classbytes, typeDescriptor);
    }

    public byte[] extract(byte[] classbytes, TypeDescriptor typeDescriptor) {
        ClassReader fileReader = new ClassReader(classbytes);
        ExtractorVisitor extractorVisitor = new ExtractorVisitor(typeDescriptor);
        fileReader.accept(extractorVisitor, 0);
        return extractorVisitor.getBytes();
    }

    class ExtractorVisitor
    implements ClassVisitor,
    Constants {
        private TypeDescriptor typeDescriptor;
        private ClassWriter interfaceWriter = new ClassWriter(0);
        private String slashedtypename;

        public ExtractorVisitor(TypeDescriptor typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
        }

        public byte[] getBytes() {
            return this.interfaceWriter.toByteArray();
        }

        @Override
        public void visit(int version, int flags, String name, String signature, String superclassName, String[] interfaceNames) {
            this.interfaceWriter.visit(version, 1537, Utils.getInterfaceName(name), null, "java/lang/Object", null);
            this.slashedtypename = name;
        }

        @Override
        public MethodVisitor visitMethod(int flags, String name, String descriptor, String signature, String[] exceptions) {
            if (this.isClinitOrInit(name)) {
                if (name.charAt(1) != 'c') {
                    String newDescriptor = this.createDescriptorWithPrefixedParameter(descriptor);
                    name = "___init___";
                    this.interfaceWriter.visitMethod(1025, name, newDescriptor, signature, exceptions);
                }
            } else {
                String newDescriptor = this.createDescriptorWithPrefixedParameter(descriptor);
                MethodMember method = this.typeDescriptor.getByDescriptor(name, descriptor);
                if (MethodMember.isClash(method)) {
                    name = "__" + name;
                }
                this.interfaceWriter.visitMethod(1025, name, newDescriptor, null, exceptions);
            }
            return null;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
        }

        @Override
        public void visitSource(String source, String debug) {
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
            String descriptor = "([Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;";
            this.interfaceWriter.visitMethod(1025, "__execute", descriptor, null, null);
            this.interfaceWriter.visitMethod(1025, "___clinit___", "()V", null, null);
            for (MethodMember method : this.typeDescriptor.getMethods()) {
                if (!MethodMember.isCatcher(method)) continue;
                descriptor = this.createDescriptorWithPrefixedParameter(method.getDescriptor());
                this.interfaceWriter.visitMethod(1025, method.getName(), descriptor, null, method.getExceptions());
            }
        }

        private String createDescriptorWithPrefixedParameter(String descriptor) {
            StringBuilder newDescriptor = new StringBuilder();
            newDescriptor.append("(L").append(this.slashedtypename).append(";");
            newDescriptor.append(descriptor, 1, descriptor.length());
            return newDescriptor.toString();
        }

        private boolean isClinitOrInit(String name) {
            return name.charAt(0) == '<';
        }
    }
}

