/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import org.springsource.loaded.Constants;
import org.springsource.loaded.MethodInvokerRewriter;
import sl.org.objectweb.asm.ClassAdapter;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassWriter;
import sl.org.objectweb.asm.MethodAdapter;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;

public class SystemClassReflectionInvestigator {
    public static int investigate(String slashedClassName, byte[] bytes) {
        ClassReader fileReader = new ClassReader(bytes);
        RewriteClassAdaptor classAdaptor = new RewriteClassAdaptor();
        fileReader.accept(classAdaptor, 4);
        return classAdaptor.hitCount;
    }

    static class RewriteClassAdaptor
    extends ClassAdapter
    implements Constants {
        int hitCount = 0;
        private ClassWriter cw = (ClassWriter)this.cv;
        int bits = 0;
        private String classname;

        private static boolean isInterceptable(String owner, String methodName) {
            return MethodInvokerRewriter.RewriteClassAdaptor.intercepted.contains(owner + "." + methodName);
        }

        public RewriteClassAdaptor() {
            super(new ClassWriter(1));
        }

        public byte[] getBytes() {
            byte[] bytes = this.cw.toByteArray();
            return bytes;
        }

        public int getBits() {
            return this.bits;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.classname = name;
        }

        @Override
        public MethodVisitor visitMethod(int flags, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(flags, name, descriptor, signature, exceptions);
            return new RewritingMethodAdapter(mv);
        }

        class RewritingMethodAdapter
        extends MethodAdapter
        implements Opcodes,
        Constants {
            int unitializedObjectsCount;

            public RewritingMethodAdapter(MethodVisitor mv) {
                super(mv);
                this.unitializedObjectsCount = 0;
            }

            private boolean interceptReflection(String owner, String name, String desc) {
                if (RewriteClassAdaptor.isInterceptable(owner, name)) {
                    ++RewriteClassAdaptor.this.hitCount;
                    System.out.println("SystemClassReflectionInvestigator: " + RewriteClassAdaptor.this.classname + "  uses " + owner + "." + name + desc);
                }
                return false;
            }

            @Override
            public void visitTypeInsn(int opcode, String type) {
                if (opcode == 187) {
                    ++this.unitializedObjectsCount;
                }
                super.visitTypeInsn(opcode, type);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (this.rewriteReflectiveCall(opcode, owner, name, desc)) {
                    return;
                }
                if (opcode == 183) {
                    --this.unitializedObjectsCount;
                }
                super.visitMethodInsn(opcode, owner, name, desc);
            }

            private boolean rewriteReflectiveCall(int opcode, String owner, String name, String desc) {
                boolean rewritten;
                return owner.length() > 10 && owner.charAt(8) == 'g' && (owner.startsWith("java/lang/reflect/") || owner.equals("java/lang/Class")) && (rewritten = this.interceptReflection(owner, name, desc));
            }
        }
    }
}

