/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springsource.loaded.FieldDelta;
import org.springsource.loaded.MethodDelta;
import sl.org.objectweb.asm.tree.FieldNode;
import sl.org.objectweb.asm.tree.MethodNode;

public class TypeDelta {
    private long changed;
    private static final long CHANGED_VERSION = 1L;
    private static final long CHANGED_ACCESS = 2L;
    private static final long CHANGED_SUPERNAME = 4L;
    private static final long CHANGED_INTERFACES = 8L;
    private static final long CHANGED_NAME = 16L;
    private static final long CHANGED_SIGNATURE = 32L;
    private static final long CHANGED_TYPE_MASK = 63L;
    private static final long CHANGED_NEWFIELDS = 64L;
    private static final long CHANGED_LOSTFIELDS = 128L;
    private static final long CHANGED_CHANGEDFIELDS = 256L;
    private static final long CHANGED_FIELD_MASK = 448L;
    private static final long CHANGED_NEWMETHODS = 512L;
    private static final long CHANGED_LOSTMETHODS = 1024L;
    private static final long CHANGED_CHANGEDMETHODS = 2048L;
    private static final long CHANGED_METHOD_MASK = 3584L;
    private static final long CHANGES = 4095L;
    public int oAccess;
    public int nAccess;
    public int oVersion;
    public int nVersion;
    public String oName;
    public String nName;
    public String oSignature;
    public String nSignature;
    public String oSuperName;
    public String nSuperName;
    public List<String> oInterfaces;
    public List<String> nInterfaces;
    Map<String, FieldNode> brandNewFields;
    Map<String, FieldNode> lostFields;
    Map<String, FieldDelta> changedFields;
    Map<String, MethodNode> brandNewMethods;
    Map<String, MethodNode> lostMethods;
    Map<String, MethodDelta> changedMethods;

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("TypeDelta Summary\n");
        s.append("TypeDeclaration changes:\n");
        if (this.hasTypeVersionChanged()) {
            s.append("typeversion changed: o=" + this.oVersion + " n=" + this.nVersion + "\n");
        }
        if (this.hasTypeAccessChanged()) {
            s.append("typeaccess changed: o=" + this.oAccess + " n=" + this.nAccess + "\n");
        }
        if (this.hasTypeSupertypeChanged()) {
            s.append("typesupertype changed: o=" + this.oSuperName + " n=" + this.nSuperName + "\n");
        }
        if (this.hasTypeInterfacesChanged()) {
            s.append("typeinterfaces changed: o=" + this.oInterfaces + " n=" + this.nInterfaces + "\n");
        }
        if (this.hasTypeNameChanged()) {
            s.append("typename changed: o=" + this.oName + " n=" + this.nName + "\n");
        }
        if (this.hasTypeSignatureChanged()) {
            s.append("typesignature changed: o=" + this.oSignature + " n=" + this.nSignature + "\n");
        }
        return s.toString();
    }

    void setTypeAccessChange(int oldAccess, int newAccess) {
        this.oAccess = oldAccess;
        this.nAccess = newAccess;
        this.changed |= 2L;
    }

    void setTypeNameChange(String oldName, String newName) {
        this.oName = oldName;
        this.nName = newName;
        this.changed |= 0x10L;
    }

    void setTypeSignatureChange(String oldSignature, String newSignature) {
        this.oSignature = oldSignature;
        this.nSignature = newSignature;
        this.changed |= 0x20L;
    }

    void setTypeSuperNameChange(String oldSuperName, String newSuperName) {
        this.oSuperName = oldSuperName;
        this.nSuperName = newSuperName;
        this.changed |= 4L;
    }

    void setTypeInterfacesChange(List<String> oldInterfaces, List<String> newInterfaces) {
        this.oInterfaces = oldInterfaces;
        this.nInterfaces = newInterfaces;
        this.changed |= 8L;
    }

    void addNewField(FieldNode nField) {
        if (this.brandNewFields == null) {
            this.brandNewFields = new HashMap<String, FieldNode>();
        }
        this.brandNewFields.put(nField.name, nField);
        this.changed |= 0x40L;
    }

    void addLostField(FieldNode lField) {
        if (this.lostFields == null) {
            this.lostFields = new HashMap<String, FieldNode>();
        }
        this.lostFields.put(lField.name, lField);
        this.changed |= 0x80L;
    }

    void addChangedField(FieldDelta fd) {
        if (this.changedFields == null) {
            this.changedFields = new HashMap<String, FieldDelta>();
        }
        this.changedFields.put(fd.name, fd);
        this.changed |= 0x100L;
    }

    void addNewMethod(MethodNode nMethod) {
        if (this.brandNewMethods == null) {
            this.brandNewMethods = new HashMap<String, MethodNode>();
        }
        this.brandNewMethods.put(nMethod.name + nMethod.desc, nMethod);
        this.changed |= 0x200L;
    }

    void addLostMethod(MethodNode nMethod) {
        if (this.lostMethods == null) {
            this.lostMethods = new HashMap<String, MethodNode>();
        }
        this.lostMethods.put(nMethod.name + nMethod.desc, nMethod);
        this.changed |= 0x400L;
    }

    void addChangedMethod(MethodDelta md) {
        if (this.changedMethods == null) {
            this.changedMethods = new HashMap<String, MethodDelta>();
        }
        this.changedMethods.put(md.name + md.desc, md);
        this.changed |= 0x800L;
    }

    public boolean hasTypeDeclarationChanged() {
        return (this.changed & 0x3FL) != 0L;
    }

    public boolean hasTypeNameChanged() {
        return (this.changed & 0x10L) != 0L;
    }

    public boolean hasTypeVersionChanged() {
        return (this.changed & 1L) != 0L;
    }

    public boolean hasTypeAccessChanged() {
        return (this.changed & 2L) != 0L;
    }

    public boolean hasTypeSupertypeChanged() {
        return (this.changed & 4L) != 0L;
    }

    public boolean hasTypeInterfacesChanged() {
        return (this.changed & 8L) != 0L;
    }

    public boolean hasTypeSignatureChanged() {
        return (this.changed & 0x20L) != 0L;
    }

    public boolean hasAnythingChanged() {
        return (this.changed & 0xFFFL) != 0L;
    }

    public boolean hasNewFields() {
        return (this.changed & 0x40L) != 0L;
    }

    public boolean hasLostFields() {
        return (this.changed & 0x80L) != 0L;
    }

    public boolean haveFieldsChangedOrBeenAddedOrRemoved() {
        return (this.changed & 0x1C0L) != 0L;
    }

    public boolean haveFieldsChanged() {
        return (this.changed & 0x100L) != 0L;
    }

    public boolean haveMethodsChanged() {
        return (this.changed & 0x800L) != 0L;
    }

    public boolean haveMethodsChangedOrBeenAddedOrRemoved() {
        return (this.changed & 0xE00L) != 0L;
    }

    public boolean haveMethodsBeenAdded() {
        return (this.changed & 0x200L) != 0L;
    }

    public boolean haveMethodsBeenDeleted() {
        return (this.changed & 0x400L) != 0L;
    }

    public Map<String, FieldNode> getNewFields() {
        return this.brandNewFields;
    }

    public Map<String, FieldNode> getLostFields() {
        return this.lostFields;
    }

    public Map<String, FieldDelta> getChangedFields() {
        return this.changedFields;
    }

    public Map<String, MethodDelta> getChangedMethods() {
        return this.changedMethods;
    }
}

