/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.agent;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.LoadtimeInstrumentationPlugin;
import org.springsource.loaded.ReloadEventProcessorPlugin;
import org.springsource.loaded.agent.ClassVisitingConstructorAppender;
import sl.org.objectweb.asm.ClassReader;

public class SpringPlugin
implements LoadtimeInstrumentationPlugin,
ReloadEventProcessorPlugin {
    private static Logger log = Logger.getLogger(SpringPlugin.class.getName());
    public static List<Object> instancesOf_AnnotationMethodHandlerAdapter = new ArrayList<Object>();
    public static List<Object> instancesOf_DefaultAnnotationHandlerMapping = new ArrayList<Object>();
    public static List<Object> instancesOf_RequestMappingHandlerMapping = new ArrayList<Object>();
    public static boolean support305 = true;
    private Field classCacheField;
    private boolean cachedIntrospectionResultsClassLoaded = false;
    private Class<?> cachedIntrospectionResultsClass = null;
    private static boolean debug = false;

    @Override
    public boolean accept(String slashedTypeName, ClassLoader classLoader, ProtectionDomain protectionDomain, byte[] bytes) {
        if (slashedTypeName == null) {
            return false;
        }
        if (slashedTypeName.equals("org/springframework/beans/CachedIntrospectionResults")) {
            this.cachedIntrospectionResultsClassLoaded = true;
        }
        return slashedTypeName.equals("org/springframework/web/servlet/mvc/annotation/AnnotationMethodHandlerAdapter") || slashedTypeName.equals("org/springframework/web/servlet/mvc/method/annotation/RequestMappingHandlerMapping") || support305 && slashedTypeName.equals("org/springframework/web/servlet/mvc/annotation/DefaultAnnotationHandlerMapping");
    }

    @Override
    public byte[] modify(String slashedClassName, ClassLoader classLoader, byte[] bytes) {
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.info("loadtime modifying " + slashedClassName);
        }
        if (slashedClassName.equals("org/springframework/web/servlet/mvc/annotation/AnnotationMethodHandlerAdapter")) {
            return this.bytesWithInstanceCreationCaptured(bytes, "org/springsource/loaded/agent/SpringPlugin", "recordAnnotationMethodHandlerAdapterInstance");
        }
        if (slashedClassName.equals("org/springframework/web/servlet/mvc/method/annotation/RequestMappingHandlerMapping")) {
            return this.bytesWithInstanceCreationCaptured(bytes, "org/springsource/loaded/agent/SpringPlugin", "recordRequestMappingHandlerMappingInstance");
        }
        return this.bytesWithInstanceCreationCaptured(bytes, "org/springsource/loaded/agent/SpringPlugin", "recordDefaultAnnotationHandlerMappingInstance");
    }

    public static void recordAnnotationMethodHandlerAdapterInstance(Object obj) {
        instancesOf_AnnotationMethodHandlerAdapter.add(obj);
    }

    public static void recordRequestMappingHandlerMappingInstance(Object obj) {
        instancesOf_RequestMappingHandlerMapping.add(obj);
    }

    public static void recordDefaultAnnotationHandlerMappingInstance(Object obj) {
        if (debug) {
            System.out.println("Recording new instance of DefaultAnnotationHandlerMappingInstance");
        }
        instancesOf_DefaultAnnotationHandlerMapping.add(obj);
    }

    @Override
    public void reloadEvent(String typename, Class<?> clazz, String versionsuffix) {
        this.removeClazzFromMethodResolverCache(clazz);
        this.clearCachedIntrospectionResults(clazz);
        this.reinvokeDetectHandlers();
        this.reinvokeInitHandlerMethods();
    }

    private void removeClazzFromMethodResolverCache(Class<?> clazz) {
        for (Object o : instancesOf_AnnotationMethodHandlerAdapter) {
            try {
                Field f = o.getClass().getDeclaredField("methodResolverCache");
                f.setAccessible(true);
                Map map = (Map)f.get(o);
                Method removeMethod = Map.class.getDeclaredMethod("remove", Object.class);
                Object ret = removeMethod.invoke((Object)map, clazz);
                if (GlobalConfiguration.debugplugins) {
                    System.err.println("SpringPlugin: clearing methodResolverCache for " + clazz.getName());
                }
                if (!GlobalConfiguration.isRuntimeLogging || !log.isLoggable(Level.INFO)) continue;
                log.info("cleared a cache entry? " + (ret != null));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unexpected problem accessing methodResolverCache on " + o, e);
            }
        }
    }

    private void clearCachedIntrospectionResults(Class<?> clazz) {
        if (this.cachedIntrospectionResultsClassLoaded) {
            try {
                if (this.cachedIntrospectionResultsClass == null) {
                    this.cachedIntrospectionResultsClass = clazz.getClassLoader().loadClass("org.springframework.beans.CachedIntrospectionResults");
                }
                if (this.classCacheField == null) {
                    this.classCacheField = this.cachedIntrospectionResultsClass.getDeclaredField("classCache");
                }
                this.classCacheField.setAccessible(true);
                Map m = (Map)this.classCacheField.get(null);
                Object o = m.remove(clazz);
                if (GlobalConfiguration.debugplugins) {
                    System.err.println("SpringPlugin: clearing CachedIntrospectionResults for " + clazz.getName() + " removed=" + o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void reinvokeDetectHandlers() {
        for (Object o : instancesOf_DefaultAnnotationHandlerMapping) {
            if (debug) {
                System.out.println("Invoking detectHandlers on instance of DefaultAnnotationHandlerMappingInstance");
            }
            try {
                Class<?> clazz_AbstractDetectingUrlHandlerMapping = o.getClass().getSuperclass();
                Method method_detectHandlers = clazz_AbstractDetectingUrlHandlerMapping.getDeclaredMethod("detectHandlers", new Class[0]);
                method_detectHandlers.setAccessible(true);
                method_detectHandlers.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                if (!GlobalConfiguration.debugplugins) continue;
                e.printStackTrace();
            }
        }
    }

    private void reinvokeInitHandlerMethods() {
        for (Object o : instancesOf_RequestMappingHandlerMapping) {
            if (debug) {
                System.out.println("Invoking initHandlerMethods on instance of RequestMappingHandlerMapping");
            }
            try {
                Class<?> clazz_AbstractHandlerMethodMapping = o.getClass().getSuperclass().getSuperclass();
                Field field_handlerMethods = clazz_AbstractHandlerMethodMapping.getDeclaredField("handlerMethods");
                field_handlerMethods.setAccessible(true);
                Map m = (Map)field_handlerMethods.get(o);
                m.clear();
                Field field_urlMap = clazz_AbstractHandlerMethodMapping.getDeclaredField("urlMap");
                field_urlMap.setAccessible(true);
                m = (Map)field_urlMap.get(o);
                m.clear();
                Method method_initHandlerMethods = clazz_AbstractHandlerMethodMapping.getDeclaredMethod("initHandlerMethods", new Class[0]);
                method_initHandlerMethods.setAccessible(true);
                method_initHandlerMethods.invoke(o, new Object[0]);
            }
            catch (NoSuchFieldException nsfe) {
                if (!log.isLoggable(Level.WARNING)) continue;
                if (nsfe.getMessage().equals("handlerMethods")) {
                    log.warning("problem resetting request mapping handlers - unable to find field 'handlerMethods' on type 'AbstractHandlerMethodMapping' - you probably are not on Spring 3.1");
                    continue;
                }
                log.warning("problem resetting request mapping handlers - NoSuchFieldException: " + nsfe.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean shouldRerunStaticInitializer(String typename, Class<?> clazz, String encodedTimestamp) {
        return false;
    }

    private byte[] bytesWithInstanceCreationCaptured(byte[] bytes, String classToCall, String methodToCall) {
        ClassReader cr = new ClassReader(bytes);
        ClassVisitingConstructorAppender ca = new ClassVisitingConstructorAppender(classToCall, methodToCall);
        cr.accept(ca, 0);
        byte[] newbytes = ca.getBytes();
        return newbytes;
    }
}

